/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class ApiMiddleware
implements Store.Middleware<State> {
    private final Provider<Api> apiProvider;

    public ApiMiddleware(Provider<Api> apiProvider) {
        this.apiProvider = apiProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case CONVERSATION_MARKED_AS_DISMISSED: {
                Conversation conversation = (Conversation)action.value();
                this.api().markConversationAsDismissed(conversation.getId());
                break;
            }
            case CONVERSATION_MARKED_AS_READ: {
                int inAppConversationCount = store.select(Selectors.OVERLAY).conversations().size();
                if (inAppConversationCount != 1 || store.select(Selectors.UNREAD_COUNT) <= inAppConversationCount) break;
                this.api().getUnreadConversations();
                break;
            }
            case FETCH_INBOX_REQUEST: {
                this.api().getInbox();
                break;
            }
            case FETCH_INBOX_BEFORE_DATE_REQUEST: {
                this.api().getInboxBefore((Long)action.value());
                break;
            }
            case NEW_COMMENT_EVENT_RECEIVED: {
                String updatedConversationId = (String)action.value();
                this.fetchDataForCurrentScreen(store, updatedConversationId);
                break;
            }
        }
    }

    private void fetchDataForCurrentScreen(Store<State> store, String updatedConversationId) {
        if (store.select(Selectors.OVERLAY).resumedHostActivity() != null || store.select(Selectors.APP_IS_BACKGROUNDED).booleanValue()) {
            this.api().getUnreadConversations();
        } else {
            this.api().getConversation(updatedConversationId);
        }
    }

    private Api api() {
        return this.apiProvider.get();
    }
}

