/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.text.TextUtils;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;

public class IntercomHelpCenterActivity
extends IntercomBaseActivity {
    public static final String LINK_TRANSITION_KEY = "link_background";
    private static final String PARCEL_HELP_CENTER_URL = "parcel_help_center_url";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final int ENTRANCE_ANIMATION_TIME_MS = 300;
    private static final int EXIT_ANIMATION_TIME_MS = 150;
    boolean titleBarEnabled = false;
    String conversationId = "";
    ProgressBar loadingView;
    WebView webView;
    MetricTracker metricTracker;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_help_center);
        Injector injector = Injector.get();
        this.metricTracker = injector.getMetricTracker();
        AppConfig appConfig = injector.getAppConfigProvider().get();
        String helpCenterUrl = "";
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            helpCenterUrl = data.getString(PARCEL_HELP_CENTER_URL, "");
            this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
        }
        if (TextUtils.isEmpty((CharSequence)helpCenterUrl)) {
            this.closeHelpCenter();
        }
        this.loadingView = (ProgressBar)this.findViewById(R.id.loading_view);
        this.loadingView.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
        this.webView = (WebView)this.findViewById(R.id.help_center_web_view);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                IntercomHelpCenterActivity.this.webView.animate().alpha(1.0f).setDuration(300L).start();
                IntercomHelpCenterActivity.this.loadingView.setVisibility(8);
                IntercomHelpCenterActivity.this.metricTracker.viewedHelpCenter(IntercomHelpCenterActivity.this.conversationId);
                IntercomHelpCenterActivity.this.webView.loadUrl("javascript:Intercom('shutdown')");
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.setClipToOutline(true);
        }
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(helpCenterUrl);
        this.findViewById(R.id.dismiss).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntercomHelpCenterActivity.this.metricTracker.closedHelpCenter(IntercomHelpCenterActivity.this.conversationId, 0);
                IntercomHelpCenterActivity.this.closeHelpCenter();
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setSharedElementEnterTransition(this.enterTransition());
            this.getWindow().setSharedElementReturnTransition(this.returnTransition());
            this.findViewById(R.id.link_view).setTransitionName(LINK_TRANSITION_KEY);
        }
    }

    void closeHelpCenter() {
        this.titleBarEnabled = false;
        this.fadeOutView((View)this.webView);
        this.supportFinishAfterTransition();
    }

    private void fadeOutView(View view) {
        view.animate().alpha(0.0f).setDuration(150L).start();
    }

    public void onBackPressed() {
        this.metricTracker.closedHelpCenter(this.conversationId, 1);
        this.closeHelpCenter();
    }

    public static Intent buildIntent(Context context, String helpCenterUrl, String conversationId) {
        Intent intent = new Intent(context, IntercomHelpCenterActivity.class);
        intent.putExtra(PARCEL_HELP_CENTER_URL, helpCenterUrl);
        intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        intent.setFlags(0x10000000);
        return intent;
    }

    @TargetApi(value=19)
    private Transition enterTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(300L);
        return bounds;
    }

    @TargetApi(value=19)
    private Transition returnTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(150L);
        return bounds;
    }
}

