/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.util.Util;

class NetworkImage
extends Image
implements ImageBlock {
    private static final int PROGRESSBAR_DIAMETER_DP = 40;
    private final Provider<AppConfig> appConfigProvider;
    private final UploadingImageCache uploadingImageCache;
    private final ImageClickListener listener;
    private final Twig twig = LumberMill.getLogger();

    NetworkImage(StyleType style2, Provider<AppConfig> appConfigProvider, UploadingImageCache uploadingImageCache, ImageClickListener listener) {
        super(style2);
        this.appConfigProvider = appConfigProvider;
        this.uploadingImageCache = uploadingImageCache;
        this.listener = listener;
    }

    public View addImage(final String url, final String linkUrl, final int width, final int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        final Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx((float)width, (Context)context);
        int heightPx = ScreenUtils.dpToPx((float)height, (Context)context);
        FrameLayout rootView = new FrameLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        final ResizableImageView imageView = new ResizableImageView(context);
        if (Build.VERSION.SDK_INT >= 21) {
            imageView.setTransitionName("lightbox_image");
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground((ImageView)imageView);
        int baseColor = this.appConfigProvider.get().getBaseColor();
        final ProgressBar spinner = new ProgressBar(context);
        int spinnerDiameterPx = ScreenUtils.dpToPx((float)40.0f, (Context)context);
        spinner.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(spinnerDiameterPx, spinnerDiameterPx, 17));
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_progress_wheel);
        drawable2.setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        spinner.setIndeterminateDrawable(drawable2);
        spinner.setIndeterminate(true);
        rootView.addView((View)imageView);
        rootView.addView((View)spinner);
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.hideLoadingState(spinner, (ImageView)imageView);
            imageView.setImageResource(R.drawable.intercom_error);
        } else {
            DrawableTypeRequest requestCreator = Glide.with((Context)context).load(url);
            this.setImageViewBounds(widthPx, heightPx, imageView, requestCreator);
            String localImagePath = this.uploadingImageCache.getLocalImagePathForRemoteUrl(url);
            Resources resources = context.getResources();
            if (!TextUtils.isEmpty((CharSequence)localImagePath)) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                options.inSampleSize = this.getSampleSize(widthPx, heightPx, displayMetrics);
                Bitmap bitmap = BitmapFactory.decodeFile((String)localImagePath, (BitmapFactory.Options)options);
                BitmapDrawable localImage = new BitmapDrawable(resources, bitmap);
                localImage.setColorFilter(ColorUtils.newGreyscaleFilter());
                requestCreator.placeholder((Drawable)localImage).dontAnimate();
            }
            requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(context, resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))}).error(R.drawable.intercom_error).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

                public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                    NetworkImage.this.hideLoadingState(spinner, (ImageView)imageView);
                    NetworkImage.this.twig.internal("images", "FAILURE");
                    return false;
                }

                public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                    NetworkImage.this.twig.internal("images", "SUCCESS");
                    NetworkImage.this.hideLoadingState(spinner, (ImageView)imageView);
                    if (NetworkImage.this.getStyle() != StyleType.CHAT_FULL) {
                        imageView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                                imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                                NetworkImage.this.listener.onImageClicked(url, linkUrl, (ImageView)imageView, width, height);
                            }
                        });
                    }
                    return false;
                }
            }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url));
            if (Util.isValidDimensions((int)width, (int)height)) {
                requestCreator.override(width, height);
            }
            requestCreator.into((ImageView)imageView);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }

    @VisibleForTesting
    int getSampleSize(int scaledWidth, int scaledHeight, DisplayMetrics displayMetrics) {
        int sampleSize = 1;
        if (scaledWidth > displayMetrics.widthPixels || scaledHeight > displayMetrics.heightPixels) {
            sampleSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log((double)displayMetrics.widthPixels / (double)Math.max(scaledHeight, scaledWidth)) / Math.log(0.5)));
        }
        return sampleSize;
    }

    void hideLoadingState(ProgressBar spinner, ImageView imageView) {
        if (spinner != null) {
            spinner.setVisibility(8);
            imageView.setBackgroundResource(17170445);
        }
    }
}

