/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.ConversationWebViewClient;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.conversation.WebViewConversationAction;
import io.intercom.android.sdk.conversation.WebViewHostWrapper;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.google.gson.Gson;
import io.intercom.okhttp3.internal.io.FileSystem;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Source;
import java.io.IOException;
import java.util.List;

class WebViewConversationContentPresenter
implements ConversationContentPresenter {
    private static final String WEB_PAGE_URL = "https://js.intercomcdn.com/mobile.html";
    private final WebView webView;
    private final ViewGroup container;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private final Provider<AppConfig> appConfigProvider;
    private final ConversationContentPresenter.Host host;
    private final Gson gson;
    private final JavascriptRunner jsRunner;
    private final View loadingView;
    private WebViewHostWrapper hostWrapper;
    private final Store<State> store;

    WebViewConversationContentPresenter(WebView webView, ViewGroup container, View loadingView, AppIdentity appIdentity, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, ConversationContentPresenter.Host host, Gson gson, JavascriptRunner jsRunner, Store<State> store) {
        this.webView = webView;
        this.container = container;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.appConfigProvider = appConfigProvider;
        this.host = host;
        this.gson = gson;
        this.jsRunner = jsRunner;
        this.loadingView = loadingView;
        this.store = store;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setup() {
        AppConfig appConfig = this.appConfigProvider.get();
        ProgressBar progressBar = (ProgressBar)this.loadingView.findViewById(R.id.progressBar);
        progressBar.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient((WebViewClient)new ConversationWebViewClient(this.jsRunner, WEB_PAGE_URL));
        this.webView.loadUrl(WEB_PAGE_URL);
        this.hostWrapper = new WebViewHostWrapper(this.host, this.webView, this.gson, this.store);
        this.webView.addJavascriptInterface((Object)this.hostWrapper, "AndroidHost");
        this.webView.setBackgroundColor(0);
        this.jsRunner.run("conversationApp.sendAction = function(action) {AndroidHost.handleAction(JSON.stringify(action));};");
    }

    @VisibleForTesting
    void sendWebViewAction(WebViewConversationAction action) {
        String actionJson = this.gson.toJson((Object)action);
        this.jsRunner.run("conversationApp.handleAction(" + actionJson + ");");
    }

    @Override
    public void smoothScrollToTop() {
        this.scrollToTop();
    }

    @Override
    public void scrollToTop() {
        this.webView.scrollTo(0, 0);
    }

    @Override
    public void scrollToBottom() {
        this.webView.scrollTo(0, this.webView.getContentHeight());
    }

    @Override
    public boolean isAtBottom() {
        return this.webView.getScrollY() + this.webView.getHeight() >= this.webView.getContentHeight();
    }

    @Override
    public void onProfileScrolled() {
    }

    @Override
    public void onGlobalLayout() {
    }

    @Override
    public void onNewPartReceived() {
    }

    @Override
    public void showErrorView() {
    }

    @Override
    public void showLoadingView() {
        this.loadingView.setVisibility(0);
        this.webView.setVisibility(4);
    }

    @Override
    public void showContentView() {
        this.webView.setVisibility(0);
        this.loadingView.setVisibility(8);
    }

    @Override
    public void onAdminStartedTyping(AdminIsTypingEvent event) {
        this.sendWebViewAction(WebViewConversationAction.adminIsTyping(event.getAdminId(), event.getAdminName(), event.getAdminAvatarUrl()));
    }

    @Override
    public void onNewCommentEventReceived(NewCommentEvent event) {
        this.sendWebViewAction(WebViewConversationAction.partCreated());
    }

    @Override
    public void fetchConversation(String conversationId) {
        this.sendWebViewAction(WebViewConversationAction.setConversation(this.appIdentity, this.userIdentity, this.appConfigProvider, conversationId));
    }

    @Override
    public void onPartClicked(Part part) {
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders) {
        this.sendWebViewAction(WebViewConversationAction.createPart(blockBuilders));
    }

    @Override
    public void uploadImage(List<Block.Builder> blocks, final GalleryImage galleryImage) {
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedSource source = Okio.buffer((Source)FileSystem.SYSTEM.source(galleryImage.buildFile()));
                    String base64Image = source.readByteString().base64();
                    source.close();
                    WebViewConversationContentPresenter.this.sendWebViewAction(WebViewConversationAction.createUpload(galleryImage.getFileName(), galleryImage.getMimeType(), base64Image));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
    }

    @Override
    public void cleanup() {
        this.jsRunner.clearPendingScripts();
    }
}

