/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.Author;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.blocks.models.Channel;
import io.intercom.android.sdk.blocks.models.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Block
implements Parcelable {
    private final List<BlockAttachment> attachments;
    private final List<String> items;
    private final Map<String, String> data;
    private final BlockType type;
    private final BlockAlignment align;
    private final Author author;
    private final Image image;
    private final String text;
    private final String title;
    private final String description;
    private final String linkType;
    private final String siteName;
    private final String articleId;
    private final String language;
    private final String url;
    private final String previewUrl;
    private final String attribution;
    private final String linkUrl;
    private final String embedUrl;
    private final String trackingUrl;
    private final String username;
    private final String provider;
    private final String id;
    private final int width;
    private final int height;
    private final List<Channel> channels;
    public static final Parcelable.Creator<Block> CREATOR = new Parcelable.Creator<Block>(){

        public Block createFromParcel(Parcel source) {
            return new Block(source);
        }

        public Block[] newArray(int size) {
            return new Block[size];
        }
    };

    Block() {
        this(new Builder());
    }

    private Block(Builder builder) {
        this.type = BlockType.typeValueOf(builder.type);
        this.text = builder.text == null ? "" : builder.text;
        this.title = builder.title == null ? "" : builder.title;
        this.description = builder.description == null ? "" : builder.description;
        this.linkType = builder.linkType == null ? "" : builder.linkType;
        this.siteName = builder.siteName == null ? "" : builder.siteName;
        this.articleId = builder.articleId == null ? "" : builder.articleId;
        this.author = builder.author == null ? new Author() : builder.author;
        this.image = builder.image == null ? new Image() : builder.image;
        this.data = builder.data == null ? new HashMap() : builder.data;
        this.language = builder.language == null ? "" : builder.language;
        this.url = builder.url == null ? "" : builder.url;
        this.linkUrl = builder.linkUrl == null ? "" : builder.linkUrl;
        this.embedUrl = builder.embedUrl == null ? "" : builder.embedUrl;
        this.trackingUrl = builder.trackingUrl == null ? "" : builder.trackingUrl;
        this.username = builder.username == null ? "" : builder.username;
        this.provider = builder.provider == null ? "" : builder.provider;
        this.id = builder.id == null ? "" : builder.id;
        this.align = BlockAlignment.alignValueOf(builder.align);
        this.width = builder.width == null ? 0 : builder.width;
        this.height = builder.height == null ? 0 : builder.height;
        this.previewUrl = builder.previewUrl == null ? "" : builder.previewUrl;
        this.attribution = builder.attribution == null ? "" : builder.attribution;
        this.attachments = new ArrayList<BlockAttachment>();
        if (builder.attachments != null) {
            for (BlockAttachment blockAttachment : builder.attachments) {
                if (blockAttachment == null) continue;
                this.attachments.add(blockAttachment);
            }
        }
        this.channels = new ArrayList<Channel>();
        if (builder.channels != null) {
            for (Channel channel : builder.channels) {
                if (channel == null) continue;
                this.channels.add(channel);
            }
        }
        this.items = new ArrayList<String>();
        if (builder.items != null) {
            for (String string : builder.items) {
                if (string == null) continue;
                this.items.add(string);
            }
        }
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        switch (this.type) {
            case PARAGRAPH: {
                builder.withText(this.text).withType(this.type.getSerializedName());
                break;
            }
            case LOCALIMAGE: 
            case IMAGE: {
                builder.withType(this.type.getSerializedName()).withUrl(this.url).withAttribution(this.attribution.isEmpty() ? null : this.attribution).withPreviewUrl(this.previewUrl.isEmpty() ? null : this.previewUrl).withHeight(this.height).withWidth(this.width);
                break;
            }
            case LOCAL_ATTACHMENT: {
                builder.withType(this.type.getSerializedName()).withAttachments(this.attachments);
            }
        }
        return builder;
    }

    public BlockType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getArticleId() {
        return this.articleId;
    }

    public Author getAuthor() {
        return this.author;
    }

    public Image getImage() {
        return this.image;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public List<String> getItems() {
        return this.items;
    }

    public List<BlockAttachment> getAttachments() {
        return this.attachments;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public BlockAlignment getAlign() {
        return this.align;
    }

    public String toString() {
        return "Block{attachments=" + this.attachments + ", items=" + this.items + ", data=" + this.data + ", type=" + (Object)((Object)this.type) + ", align=" + (Object)((Object)this.align) + ", author=" + this.author + ", image=" + this.image + ", text='" + this.text + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", linkType='" + this.linkType + '\'' + ", siteName='" + this.siteName + '\'' + ", articleId='" + this.articleId + '\'' + ", language='" + this.language + '\'' + ", url='" + this.url + '\'' + ", previewUrl='" + this.previewUrl + '\'' + ", attribution='" + this.attribution + '\'' + ", linkUrl='" + this.linkUrl + '\'' + ", embedUrl='" + this.embedUrl + '\'' + ", trackingUrl='" + this.trackingUrl + '\'' + ", username='" + this.username + '\'' + ", provider='" + this.provider + '\'' + ", id='" + this.id + '\'' + ", width=" + this.width + ", height=" + this.height + ", channels=" + this.channels + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.width != block.width) {
            return false;
        }
        if (this.height != block.height) {
            return false;
        }
        if (this.attachments != null ? !this.attachments.equals(block.attachments) : block.attachments != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(block.items) : block.items != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(block.data) : block.data != null) {
            return false;
        }
        if (this.type != block.type) {
            return false;
        }
        if (this.align != block.align) {
            return false;
        }
        if (this.author != null ? !this.author.equals(block.author) : block.author != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(block.image) : block.image != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(block.text) : block.text != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(block.title) : block.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(block.description) : block.description != null) {
            return false;
        }
        if (this.linkType != null ? !this.linkType.equals(block.linkType) : block.linkType != null) {
            return false;
        }
        if (this.siteName != null ? !this.siteName.equals(block.siteName) : block.siteName != null) {
            return false;
        }
        if (this.articleId != null ? !this.articleId.equals(block.articleId) : block.articleId != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(block.language) : block.language != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(block.url) : block.url != null) {
            return false;
        }
        if (this.linkUrl != null ? !this.linkUrl.equals(block.linkUrl) : block.linkUrl != null) {
            return false;
        }
        if (this.embedUrl != null ? !this.embedUrl.equals(block.embedUrl) : block.embedUrl != null) {
            return false;
        }
        if (this.trackingUrl != null ? !this.trackingUrl.equals(block.trackingUrl) : block.trackingUrl != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(block.username) : block.username != null) {
            return false;
        }
        if (this.provider != null ? !this.provider.equals(block.provider) : block.provider != null) {
            return false;
        }
        if (this.previewUrl != null ? !this.previewUrl.equals(block.previewUrl) : block.previewUrl != null) {
            return false;
        }
        if (this.attribution != null ? !this.attribution.equals(block.attribution) : block.attribution != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(block.id) : block.id != null) {
            return false;
        }
        return this.channels != null ? this.channels.equals(block.channels) : block.channels == null;
    }

    public int hashCode() {
        int result = this.attachments != null ? this.attachments.hashCode() : 0;
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.align != null ? this.align.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.linkType != null ? this.linkType.hashCode() : 0);
        result = 31 * result + (this.siteName != null ? this.siteName.hashCode() : 0);
        result = 31 * result + (this.articleId != null ? this.articleId.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.linkUrl != null ? this.linkUrl.hashCode() : 0);
        result = 31 * result + (this.embedUrl != null ? this.embedUrl.hashCode() : 0);
        result = 31 * result + (this.trackingUrl != null ? this.trackingUrl.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.previewUrl != null ? this.previewUrl.hashCode() : 0);
        result = 31 * result + (this.attribution != null ? this.attribution.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.channels != null ? this.channels.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.attachments);
        dest.writeStringList(this.items);
        dest.writeInt(this.data.size());
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeInt(this.align == null ? -1 : this.align.ordinal());
        dest.writeParcelable((Parcelable)this.author, flags);
        dest.writeParcelable((Parcelable)this.image, flags);
        dest.writeString(this.text);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeString(this.linkType);
        dest.writeString(this.siteName);
        dest.writeString(this.articleId);
        dest.writeString(this.language);
        dest.writeString(this.url);
        dest.writeString(this.linkUrl);
        dest.writeString(this.embedUrl);
        dest.writeString(this.trackingUrl);
        dest.writeString(this.username);
        dest.writeString(this.provider);
        dest.writeString(this.previewUrl);
        dest.writeString(this.attribution);
        dest.writeString(this.id);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeTypedList(this.channels);
    }

    protected Block(Parcel in) {
        this.attachments = in.createTypedArrayList(BlockAttachment.CREATOR);
        this.items = in.createStringArrayList();
        int dataSize = in.readInt();
        this.data = new HashMap<String, String>(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.data.put(key, value);
        }
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : BlockType.values()[tmpType];
        int tmpAlign = in.readInt();
        this.align = tmpAlign == -1 ? null : BlockAlignment.values()[tmpAlign];
        this.author = (Author)in.readParcelable(Author.class.getClassLoader());
        this.image = (Image)in.readParcelable(Image.class.getClassLoader());
        this.text = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.linkType = in.readString();
        this.siteName = in.readString();
        this.articleId = in.readString();
        this.language = in.readString();
        this.url = in.readString();
        this.linkUrl = in.readString();
        this.embedUrl = in.readString();
        this.trackingUrl = in.readString();
        this.username = in.readString();
        this.provider = in.readString();
        this.previewUrl = in.readString();
        this.attribution = in.readString();
        this.id = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
        this.channels = in.createTypedArrayList(Channel.CREATOR);
    }

    public static final class Builder {
        String type;
        String text;
        String title;
        String description;
        String linkType;
        String siteName;
        String articleId;
        Author author;
        Image image;
        Map<String, String> data;
        String language;
        String url;
        String linkUrl;
        String embedUrl;
        String trackingUrl;
        String username;
        String provider;
        String id;
        String align;
        Integer width;
        Integer height;
        String previewUrl;
        String attribution;
        List<BlockAttachment> attachments;
        List<String> items;
        List<Channel> channels;

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withLinkType(String linkType) {
            this.linkType = linkType;
            return this;
        }

        public Builder withSiteName(String siteName) {
            this.siteName = siteName;
            return this;
        }

        public Builder withArticleId(String articleId) {
            this.articleId = articleId;
            return this;
        }

        public Builder withAuthor(Author author) {
            this.author = author;
            return this;
        }

        public Builder withImage(Image image) {
            this.image = image;
            return this;
        }

        public Builder withData(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withAlign(String align) {
            this.align = align;
            return this;
        }

        public Builder withHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withItems(List<String> items) {
            this.items = items;
            return this;
        }

        public Builder withPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            return this;
        }

        public Builder withAttribution(String attribution) {
            this.attribution = attribution;
            return this;
        }

        public Builder withAttachments(List<BlockAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withChannels(List<Channel> channels) {
            this.channels = channels;
            return this;
        }

        public Block build() {
            return new Block(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (this.type != null ? !this.type.equals(builder.type) : builder.type != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(builder.text) : builder.text != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(builder.title) : builder.title != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(builder.description) : builder.description != null) {
                return false;
            }
            if (this.linkType != null ? !this.linkType.equals(builder.linkType) : builder.linkType != null) {
                return false;
            }
            if (this.siteName != null ? !this.siteName.equals(builder.siteName) : builder.siteName != null) {
                return false;
            }
            if (this.articleId != null ? !this.articleId.equals(builder.articleId) : builder.articleId != null) {
                return false;
            }
            if (this.author != null ? !this.author.equals(builder.author) : builder.author != null) {
                return false;
            }
            if (this.image != null ? !this.image.equals(builder.image) : builder.image != null) {
                return false;
            }
            if (this.data != null ? !this.data.equals(builder.data) : builder.data != null) {
                return false;
            }
            if (this.language != null ? !this.language.equals(builder.language) : builder.language != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(builder.url) : builder.url != null) {
                return false;
            }
            if (this.linkUrl != null ? !this.linkUrl.equals(builder.linkUrl) : builder.linkUrl != null) {
                return false;
            }
            if (this.embedUrl != null ? !this.embedUrl.equals(builder.embedUrl) : builder.embedUrl != null) {
                return false;
            }
            if (this.trackingUrl != null ? !this.trackingUrl.equals(builder.trackingUrl) : builder.trackingUrl != null) {
                return false;
            }
            if (this.username != null ? !this.username.equals(builder.username) : builder.username != null) {
                return false;
            }
            if (this.provider != null ? !this.provider.equals(builder.provider) : builder.provider != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(builder.id) : builder.id != null) {
                return false;
            }
            if (this.align != null ? !this.align.equals(builder.align) : builder.align != null) {
                return false;
            }
            if (this.width != null ? !this.width.equals(builder.width) : builder.width != null) {
                return false;
            }
            if (this.height != null ? !this.height.equals(builder.height) : builder.height != null) {
                return false;
            }
            if (this.previewUrl != null ? !this.previewUrl.equals(builder.previewUrl) : builder.previewUrl != null) {
                return false;
            }
            if (this.attribution != null ? !this.attribution.equals(builder.attribution) : builder.attribution != null) {
                return false;
            }
            if (this.attachments != null ? !this.attachments.equals(builder.attachments) : builder.attachments != null) {
                return false;
            }
            if (this.items != null ? !this.items.equals(builder.items) : builder.items != null) {
                return false;
            }
            return this.channels != null ? this.channels.equals(builder.channels) : builder.channels == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.linkType != null ? this.linkType.hashCode() : 0);
            result = 31 * result + (this.siteName != null ? this.siteName.hashCode() : 0);
            result = 31 * result + (this.articleId != null ? this.articleId.hashCode() : 0);
            result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.linkUrl != null ? this.linkUrl.hashCode() : 0);
            result = 31 * result + (this.embedUrl != null ? this.embedUrl.hashCode() : 0);
            result = 31 * result + (this.trackingUrl != null ? this.trackingUrl.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.previewUrl != null ? this.previewUrl.hashCode() : 0);
            result = 31 * result + (this.attribution != null ? this.attribution.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.align != null ? this.align.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.attachments != null ? this.attachments.hashCode() : 0);
            result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
            result = 31 * result + (this.channels != null ? this.channels.hashCode() : 0);
            return result;
        }
    }
}

