/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.NullSafety;

public class Participant
implements Parcelable {
    public static final String ADMIN_TYPE = "admin";
    public static final String USER_TYPE = "user";
    private final String id;
    private final String name;
    private final String type;
    private final String email;
    private final Avatar avatar;
    public static final Participant NULL = new Participant();
    public static final Parcelable.Creator<Participant> CREATOR = new Parcelable.Creator<Participant>(){

        public Participant createFromParcel(Parcel in) {
            return new Participant(in);
        }

        public Participant[] newArray(int size) {
            return new Participant[size];
        }
    };

    public Participant() {
        this(new Builder());
    }

    Participant(Builder builder) {
        this.id = NullSafety.valueOrEmpty(builder.id);
        this.name = NullSafety.valueOrEmpty(builder.name);
        this.type = builder.type == null ? USER_TYPE : builder.type;
        this.email = NullSafety.valueOrEmpty(builder.email);
        String initial = NameUtils.getInitial(this.nameOrEmail());
        this.avatar = builder.avatar == null ? new Avatar.Builder().withInitials(initial).build() : builder.avatar.withInitials(initial).build();
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public boolean isAdmin() {
        return ADMIN_TYPE.equals(this.type);
    }

    @VisibleForTesting
    String nameOrEmail() {
        return this.name.isEmpty() ? this.email : this.name;
    }

    public String getForename() {
        return this.nameOrEmail().trim().split(" ")[0];
    }

    public boolean isUserWithId(@Nullable String userId) {
        return USER_TYPE.equals(this.type) && this.id.equals(userId);
    }

    public static boolean isNull(@Nullable Participant participant) {
        return NULL.equals(participant) || participant == null;
    }

    private Participant(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.type = in.readString();
        this.email = in.readString();
        this.avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeString(this.type);
        dest.writeString(this.email);
        dest.writeValue((Object)this.avatar);
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String type;
        @Nullable
        String email;
        @Nullable
        Avatar.Builder avatar;

        public Participant build() {
            return new Participant(this);
        }

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withAvatar(Avatar.Builder avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }
    }
}

