/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.ChatFull;
import io.intercom.android.sdk.overlay.ChatSnippet;
import io.intercom.android.sdk.overlay.InAppNotification;
import io.intercom.android.sdk.overlay.StackableSnippet;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.android.sdk.utilities.ViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class InAppNotificationManager
implements InAppNotification.Listener,
View.OnClickListener {
    private static final int PILL_START_OFFSET_DP = 66;
    private static final int MAX_DISPLAYED_NOTIFICATIONS = 3;
    private final Twig twig = LumberMill.getLogger();
    private final Listener listener;
    private final LayoutInflater inflater;
    private final Map<String, InAppNotification> notifications = new HashMap<String, InAppNotification>();
    private final List<Conversation> lastDisplayedConversations = new ArrayList<Conversation>();
    final Handler handler;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private final Provider<AppConfig> appConfigProvider;
    private boolean hasAnimated = false;
    private float pillPosition;

    public InAppNotificationManager(LayoutInflater inflater, Handler handler, Listener listener, MetricsStore metricsStore, MetricFactory metricFactory, Provider<AppConfig> appConfigProvider) {
        this.inflater = inflater;
        this.listener = listener;
        this.handler = handler;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
        this.appConfigProvider = appConfigProvider;
    }

    public void displayNotifications(final ViewGroup root, final List<Conversation> conversations) {
        ViewUtils.waitForViewAttachment((View)root, new Runnable(){

            @Override
            public void run() {
                InAppNotificationManager.this.displayNotificationsAfterAttach(conversations, root);
            }
        });
    }

    void displayNotificationsAfterAttach(List<Conversation> conversations, ViewGroup root) {
        boolean hasChanged = !this.lastDisplayedConversations.equals(conversations) && !this.notifications.isEmpty();
        HashMap<String, InAppNotification> notifications = new HashMap<String, InAppNotification>(this.notifications);
        if (hasChanged) {
            this.updateNotifications(conversations, notifications, root);
        } else if (!this.isDisplaying()) {
            this.addNewNotifications(conversations, root);
        }
        this.hasAnimated = true;
        Resources res = root.getResources();
        this.pillPosition = root.getHeight() - res.getDimensionPixelSize(R.dimen.intercom_overlay_pill_bottom_margin) - res.getDimensionPixelSize(R.dimen.intercom_bottom_padding);
        this.displayPill(this.inflater, root);
        this.lastDisplayedConversations.clear();
        this.lastDisplayedConversations.addAll(conversations);
    }

    public boolean isDisplaying() {
        return !this.notifications.isEmpty();
    }

    public void reset(ViewGroup root) {
        for (InAppNotification notification : this.notifications.values()) {
            notification.removeView();
        }
        View pill = root.findViewById(R.id.notification_pill);
        if (pill != null) {
            root.removeView(pill);
        }
        this.notifications.clear();
    }

    @Override
    public void onInAppNotificationTap(Conversation conversation) {
        this.listener.openNotification(conversation);
    }

    @Override
    public void onInAppNotificationDismiss(InAppNotification notification) {
        Part lastPart;
        ViewGroup rootView = null;
        try {
            rootView = this.listener.getRootView();
        }
        catch (Exception e) {
            this.twig.internal("Couldn't get root view: " + e.getMessage());
        }
        Conversation conversation = notification.getConversation();
        if (rootView != null) {
            this.listener.markAsDismissed(conversation);
            rootView.removeView(notification.getRootView());
            this.notifications.remove(conversation.getId());
            this.lastDisplayedConversations.remove(conversation);
            for (InAppNotification current : this.notifications.values()) {
                current.moveForward(rootView, this.inflater);
            }
            this.displayPill(this.inflater, rootView);
            if (this.notifications.isEmpty()) {
                this.hasAnimated = false;
            }
        }
        if ("chat".equals((lastPart = conversation.getLastAdminPart()).getMessageStyle()) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
            this.metricsStore.track(this.metricFactory.closedInAppFromFull(conversation.getId(), lastPart.getId()));
        } else if (lastPart.isInitialMessage()) {
            this.metricsStore.track(this.metricFactory.dismissInAppMessageSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStore.track(this.metricFactory.dismissInAppCommentSnippet(conversation.getId(), lastPart.getId()));
        }
    }

    public void onClick(View view) {
        view.getContext().startActivity(IntercomMessengerActivity.openInbox(view.getContext()));
    }

    private void addNewNotifications(List<Conversation> conversations, ViewGroup root) {
        int count = conversations.size();
        for (int i = 0; i < count; ++i) {
            Conversation conversation = conversations.get(i);
            Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
            Part lastPart = conversation.getLastPart();
            InAppNotification notification = count >= 2 || !"chat".equals(lastPart.getMessageStyle()) ? new StackableSnippet(localisedContext, conversation, i, this.handler, root.getHeight(), this, this.appConfigProvider) : (lastPart.getDeliveryOption() == Part.DeliveryOption.SUMMARY ? new ChatSnippet(localisedContext, conversation, i, root.getHeight(), this, this.appConfigProvider) : new ChatFull(localisedContext, conversation, i, root.getHeight(), this, this.metricsStore, this.metricFactory, this.appConfigProvider));
            this.notifications.put(conversation.getId(), notification);
            if (i >= 3) continue;
            notification.display(root, this.inflater, !this.hasAnimated);
        }
    }

    private void updateNotifications(final List<Conversation> conversations, final Map<String, InAppNotification> notifications, final ViewGroup root) {
        final Conversation conversation = conversations.get(0);
        Iterator<InAppNotification> iterator = notifications.values().iterator();
        InAppNotification firstNotification = iterator.next();
        while (iterator.hasNext()) {
            InAppNotification p = iterator.next();
            if (p.getPosition() >= firstNotification.getPosition()) continue;
            firstNotification = p;
        }
        if (this.isReply(conversation)) {
            firstNotification.update(conversation, new Runnable(){

                @Override
                public void run() {
                    InAppNotificationManager.this.syncUpdates(conversations, notifications, root);
                }
            });
        } else if (notifications.size() == 1 && firstNotification instanceof ChatSnippet) {
            firstNotification.moveBackward(root, new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InAppNotificationManager.this.addNewView(conversation, root, notifications);
                    InAppNotificationManager.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            InAppNotificationManager.this.syncUpdates(conversations, notifications, root);
                        }
                    }, 220L);
                }
            });
        } else {
            for (InAppNotification notification : notifications.values()) {
                if (notification.getPosition() < 3) {
                    notification.moveBackward(root);
                    continue;
                }
                notification.setPosition(notification.getPosition() + 1);
            }
            this.addNewView(conversation, root, notifications);
            this.syncUpdates(conversations, notifications, root);
        }
    }

    void addNewView(Conversation conversation, ViewGroup root, Map<String, InAppNotification> temp) {
        Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
        StackableSnippet notification = new StackableSnippet(localisedContext, conversation, 0, this.handler, root.getHeight(), this, this.appConfigProvider);
        ((InAppNotification)notification).display(root, this.inflater, true);
        if (temp.containsKey(conversation.getId())) {
            temp.get(conversation.getId()).removeView();
        }
        temp.put(conversation.getId(), notification);
    }

    void syncUpdates(List<Conversation> conversations, Map<String, InAppNotification> notifications, ViewGroup root) {
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation conversation = conversations.get(i);
            InAppNotification notification = notifications.remove(conversation.getId());
            if (notification instanceof ChatSnippet && i > 0 || notification == null) {
                if (notification != null) {
                    notification.removeView();
                }
                Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
                notification = new StackableSnippet(localisedContext, conversation, i, this.handler, root.getHeight(), this, this.appConfigProvider);
            }
            if (i < 3) {
                notification.display(root, conversation, this.inflater, false);
            } else {
                notification.removeView();
            }
            this.notifications.put(conversation.getId(), notification);
        }
        for (InAppNotification notification : notifications.values()) {
            notification.removeView();
        }
    }

    private void displayPill(LayoutInflater inflater, ViewGroup root) {
        TextView pill = (TextView)root.findViewById(R.id.notification_pill);
        if (this.notifications.size() <= 3) {
            if (pill != null) {
                root.removeView((View)pill);
            }
        } else {
            if (pill == null) {
                inflater.inflate(R.layout.intercom_notification_pill, root, true);
                pill = (TextView)root.findViewById(R.id.notification_pill);
                pill.setAlpha(0.0f);
                pill.setScaleX(0.4f);
                pill.setScaleY(0.4f);
                pill.setY(this.pillPosition);
                pill.setOnClickListener((View.OnClickListener)this);
                this.animatePill((View)pill);
            }
            Context localised = ContextLocaliser.create().createLocalisedContext(pill.getContext());
            Phrase.from(localised, R.string.intercom_pill_display_text).put("n", this.notifications.size() - 3).into(pill);
        }
    }

    private void animatePill(final View view) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                view.setY(InAppNotificationManager.this.pillPosition + (float)ScreenUtils.dpToPx((float)66.0f, (Context)view.getContext()));
                view.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator()).y(InAppNotificationManager.this.pillPosition).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).start();
            }
        }, (long)(500.0f * SystemSettings.getTransitionScale(view.getContext())));
    }

    private boolean isReply(Conversation conversation) {
        return !this.lastDisplayedConversations.isEmpty() && conversation.getId().equals(this.lastDisplayedConversations.get(0).getId());
    }

    static interface Listener {
        public ViewGroup getRootView() throws Exception;

        public void markAsDismissed(Conversation var1);

        public void openNotification(Conversation var1);
    }
}

