/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.text.Spanned;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.blockInterfaces.CodeBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.BlockUtils;

class Code
implements CodeBlock {
    private final Context context;

    Code(Context context) {
        this.context = context;
    }

    public View addCode(Spanned code, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview = this.getCodeBlockView(code);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        return textview;
    }

    private TextView getCodeBlockView(Spanned text) {
        TextView textView = new TextView(this.context);
        textView.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white));
        textView.setTextSize(14.0f);
        textView.setText((CharSequence)text);
        textView.setPadding(this.dpToPx(14), this.dpToPx(12), this.dpToPx(14), this.dpToPx(14));
        textView.setBackgroundResource(R.color.intercom_slate_grey_two);
        textView.setTypeface(Typeface.MONOSPACE);
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)textView);
        return textView;
    }

    private int dpToPx(int densityPixels) {
        return ScreenUtils.convertDpToPixel((float)densityPixels, (Context)this.context);
    }
}

