/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.okio;

import io.intercom.okio.Buffer;
import io.intercom.okio.ByteString;
import io.intercom.okio.ForwardingSink;
import io.intercom.okio.Segment;
import io.intercom.okio.Sink;
import io.intercom.okio.Util;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    private HashingSink(Sink sink, String algorithm) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        int toHash;
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        Segment s = source.head;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            toHash = (int)Math.min(byteCount - hashedCount, (long)(s.limit - s.pos));
            this.messageDigest.update(s.data, s.pos, toHash);
            s = s.next;
        }
        super.write(source, byteCount);
    }

    public ByteString hash() {
        byte[] result = this.messageDigest.digest();
        return ByteString.of(result);
    }
}

