/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TableLayout;
import android.widget.TextView;
import io.intercom.com.facebook.rebound.OrigamiValueConverter;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringConfigRegistry;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import io.intercom.com.facebook.rebound.ui.Util;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpringConfiguratorView
extends FrameLayout {
    private static final int MAX_SEEKBAR_VAL = 100000;
    private static final float MIN_TENSION = 0.0f;
    private static final float MAX_TENSION = 200.0f;
    private static final float MIN_FRICTION = 0.0f;
    private static final float MAX_FRICTION = 50.0f;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    private final SpinnerAdapter spinnerAdapter;
    private final List<SpringConfig> mSpringConfigs = new ArrayList<SpringConfig>();
    private final Spring mRevealerSpring;
    private final float mStashPx;
    private final float mRevealPx;
    private final SpringConfigRegistry springConfigRegistry;
    private final int mTextColor = Color.argb((int)255, (int)225, (int)225, (int)225);
    private SeekBar mTensionSeekBar;
    private SeekBar mFrictionSeekBar;
    private Spinner mSpringSelectorSpinner;
    private TextView mFrictionLabel;
    private TextView mTensionLabel;
    private SpringConfig mSelectedSpringConfig;

    public SpringConfiguratorView(Context context) {
        this(context, null);
    }

    public SpringConfiguratorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @TargetApi(value=11)
    public SpringConfiguratorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        SpringSystem springSystem = SpringSystem.create();
        this.springConfigRegistry = SpringConfigRegistry.getInstance();
        this.spinnerAdapter = new SpinnerAdapter(context);
        Resources resources = this.getResources();
        this.mRevealPx = Util.dpToPx(40.0f, resources);
        this.mStashPx = Util.dpToPx(280.0f, resources);
        this.mRevealerSpring = springSystem.createSpring();
        RevealerSpringListener revealerSpringListener = new RevealerSpringListener();
        this.mRevealerSpring.setCurrentValue(1.0).setEndValue(1.0).addListener(revealerSpringListener);
        this.addView(this.generateHierarchy(context));
        SeekbarListener seekbarListener = new SeekbarListener();
        this.mTensionSeekBar.setMax(100000);
        this.mTensionSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)seekbarListener);
        this.mFrictionSeekBar.setMax(100000);
        this.mFrictionSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)seekbarListener);
        this.mSpringSelectorSpinner.setAdapter((android.widget.SpinnerAdapter)this.spinnerAdapter);
        this.mSpringSelectorSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new SpringSelectedListener());
        this.refreshSpringConfigurations();
        this.setTranslationY(this.mStashPx);
    }

    private View generateHierarchy(Context context) {
        Resources resources = this.getResources();
        int fivePx = Util.dpToPx(5.0f, resources);
        int tenPx = Util.dpToPx(10.0f, resources);
        int twentyPx = Util.dpToPx(20.0f, resources);
        TableLayout.LayoutParams tableLayoutParams = new TableLayout.LayoutParams(0, -2, 1.0f);
        tableLayoutParams.setMargins(0, 0, fivePx, 0);
        FrameLayout root = new FrameLayout(context);
        FrameLayout.LayoutParams params = Util.createLayoutParams(-1, Util.dpToPx(300.0f, resources));
        root.setLayoutParams((ViewGroup.LayoutParams)params);
        FrameLayout container = new FrameLayout(context);
        params = Util.createMatchParams();
        params.setMargins(0, twentyPx, 0, 0);
        container.setLayoutParams((ViewGroup.LayoutParams)params);
        container.setBackgroundColor(Color.argb((int)100, (int)0, (int)0, (int)0));
        root.addView((View)container);
        this.mSpringSelectorSpinner = new Spinner(context, 0);
        params = Util.createMatchWrapParams();
        params.gravity = 48;
        params.setMargins(tenPx, tenPx, tenPx, 0);
        this.mSpringSelectorSpinner.setLayoutParams((ViewGroup.LayoutParams)params);
        container.addView((View)this.mSpringSelectorSpinner);
        LinearLayout linearLayout = new LinearLayout(context);
        params = Util.createMatchWrapParams();
        params.setMargins(0, 0, 0, Util.dpToPx(80.0f, resources));
        params.gravity = 80;
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        linearLayout.setOrientation(1);
        container.addView((View)linearLayout);
        LinearLayout seekWrapper = new LinearLayout(context);
        params = Util.createMatchWrapParams();
        params.setMargins(tenPx, tenPx, tenPx, twentyPx);
        seekWrapper.setPadding(tenPx, tenPx, tenPx, tenPx);
        seekWrapper.setLayoutParams((ViewGroup.LayoutParams)params);
        seekWrapper.setOrientation(0);
        linearLayout.addView((View)seekWrapper);
        this.mTensionSeekBar = new SeekBar(context);
        this.mTensionSeekBar.setLayoutParams((ViewGroup.LayoutParams)tableLayoutParams);
        seekWrapper.addView((View)this.mTensionSeekBar);
        this.mTensionLabel = new TextView(this.getContext());
        this.mTensionLabel.setTextColor(this.mTextColor);
        params = Util.createLayoutParams(Util.dpToPx(50.0f, resources), -1);
        this.mTensionLabel.setGravity(19);
        this.mTensionLabel.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTensionLabel.setMaxLines(1);
        seekWrapper.addView((View)this.mTensionLabel);
        seekWrapper = new LinearLayout(context);
        params = Util.createMatchWrapParams();
        params.setMargins(tenPx, tenPx, tenPx, twentyPx);
        seekWrapper.setPadding(tenPx, tenPx, tenPx, tenPx);
        seekWrapper.setLayoutParams((ViewGroup.LayoutParams)params);
        seekWrapper.setOrientation(0);
        linearLayout.addView((View)seekWrapper);
        this.mFrictionSeekBar = new SeekBar(context);
        this.mFrictionSeekBar.setLayoutParams((ViewGroup.LayoutParams)tableLayoutParams);
        seekWrapper.addView((View)this.mFrictionSeekBar);
        this.mFrictionLabel = new TextView(this.getContext());
        this.mFrictionLabel.setTextColor(this.mTextColor);
        params = Util.createLayoutParams(Util.dpToPx(50.0f, resources), -1);
        this.mFrictionLabel.setGravity(19);
        this.mFrictionLabel.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mFrictionLabel.setMaxLines(1);
        seekWrapper.addView((View)this.mFrictionLabel);
        View nub = new View(context);
        params = Util.createLayoutParams(Util.dpToPx(60.0f, resources), Util.dpToPx(40.0f, resources));
        params.gravity = 49;
        nub.setLayoutParams((ViewGroup.LayoutParams)params);
        nub.setOnTouchListener((View.OnTouchListener)new OnNubTouchListener());
        nub.setBackgroundColor(Color.argb((int)255, (int)0, (int)164, (int)209));
        root.addView(nub);
        return root;
    }

    public void destroy() {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.removeView((View)this);
        }
        this.mRevealerSpring.destroy();
    }

    public void refreshSpringConfigurations() {
        Map<SpringConfig, String> springConfigMap = this.springConfigRegistry.getAllSpringConfig();
        this.spinnerAdapter.clear();
        this.mSpringConfigs.clear();
        for (Map.Entry<SpringConfig, String> entry : springConfigMap.entrySet()) {
            if (entry.getKey() == SpringConfig.defaultConfig) continue;
            this.mSpringConfigs.add(entry.getKey());
            this.spinnerAdapter.add(entry.getValue());
        }
        this.mSpringConfigs.add(SpringConfig.defaultConfig);
        this.spinnerAdapter.add(springConfigMap.get(SpringConfig.defaultConfig));
        this.spinnerAdapter.notifyDataSetChanged();
        if (this.mSpringConfigs.size() > 0) {
            this.mSpringSelectorSpinner.setSelection(0);
        }
    }

    private void updateSeekBarsForSpringConfig(SpringConfig springConfig) {
        float tension = (float)OrigamiValueConverter.origamiValueFromTension(springConfig.tension);
        float tensionRange = 200.0f;
        int scaledTension = Math.round((tension - 0.0f) * 100000.0f / tensionRange);
        float friction = (float)OrigamiValueConverter.origamiValueFromFriction(springConfig.friction);
        float frictionRange = 50.0f;
        int scaledFriction = Math.round((friction - 0.0f) * 100000.0f / frictionRange);
        this.mTensionSeekBar.setProgress(scaledTension);
        this.mFrictionSeekBar.setProgress(scaledFriction);
    }

    private void togglePosition() {
        double currentValue = this.mRevealerSpring.getEndValue();
        this.mRevealerSpring.setEndValue(currentValue == 1.0 ? 0.0 : 1.0);
    }

    private class SpinnerAdapter
    extends BaseAdapter {
        private final Context mContext;
        private final List<String> mStrings;

        public SpinnerAdapter(Context context) {
            this.mContext = context;
            this.mStrings = new ArrayList<String>();
        }

        public int getCount() {
            return this.mStrings.size();
        }

        public Object getItem(int position) {
            return this.mStrings.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public void add(String string2) {
            this.mStrings.add(string2);
            this.notifyDataSetChanged();
        }

        public void clear() {
            this.mStrings.clear();
            this.notifyDataSetChanged();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView textView;
            if (convertView == null) {
                textView = new TextView(this.mContext);
                AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
                textView.setLayoutParams((ViewGroup.LayoutParams)params);
                int twelvePx = Util.dpToPx(12.0f, SpringConfiguratorView.this.getResources());
                textView.setPadding(twelvePx, twelvePx, twelvePx, twelvePx);
                textView.setTextColor(SpringConfiguratorView.this.mTextColor);
            } else {
                textView = (TextView)convertView;
            }
            textView.setText((CharSequence)this.mStrings.get(position));
            return textView;
        }
    }

    private class RevealerSpringListener
    implements SpringListener {
        private RevealerSpringListener() {
        }

        @Override
        public void onSpringUpdate(Spring spring) {
            float val = (float)spring.getCurrentValue();
            float minTranslate = SpringConfiguratorView.this.mRevealPx;
            float maxTranslate = SpringConfiguratorView.this.mStashPx;
            float range = maxTranslate - minTranslate;
            float yTranslate = val * range + minTranslate;
            SpringConfiguratorView.this.setTranslationY(yTranslate);
        }

        @Override
        public void onSpringAtRest(Spring spring) {
        }

        @Override
        public void onSpringActivate(Spring spring) {
        }

        @Override
        public void onSpringEndStateChange(Spring spring) {
        }
    }

    private class OnNubTouchListener
    implements View.OnTouchListener {
        private OnNubTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0) {
                SpringConfiguratorView.this.togglePosition();
            }
            return true;
        }
    }

    private class SeekbarListener
    implements SeekBar.OnSeekBarChangeListener {
        private SeekbarListener() {
        }

        public void onProgressChanged(SeekBar seekBar, int val, boolean b) {
            float tensionRange = 200.0f;
            float frictionRange = 50.0f;
            if (seekBar == SpringConfiguratorView.this.mTensionSeekBar) {
                float scaledTension = (float)val * tensionRange / 100000.0f + 0.0f;
                ((SpringConfiguratorView)SpringConfiguratorView.this).mSelectedSpringConfig.tension = OrigamiValueConverter.tensionFromOrigamiValue(scaledTension);
                String roundedTensionLabel = DECIMAL_FORMAT.format(scaledTension);
                SpringConfiguratorView.this.mTensionLabel.setText((CharSequence)("T:" + roundedTensionLabel));
            }
            if (seekBar == SpringConfiguratorView.this.mFrictionSeekBar) {
                float scaledFriction = (float)val * frictionRange / 100000.0f + 0.0f;
                ((SpringConfiguratorView)SpringConfiguratorView.this).mSelectedSpringConfig.friction = OrigamiValueConverter.frictionFromOrigamiValue(scaledFriction);
                String roundedFrictionLabel = DECIMAL_FORMAT.format(scaledFriction);
                SpringConfiguratorView.this.mFrictionLabel.setText((CharSequence)("F:" + roundedFrictionLabel));
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
        }
    }

    private class SpringSelectedListener
    implements AdapterView.OnItemSelectedListener {
        private SpringSelectedListener() {
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
            SpringConfiguratorView.this.mSelectedSpringConfig = (SpringConfig)SpringConfiguratorView.this.mSpringConfigs.get(i);
            SpringConfiguratorView.this.updateSeekBarsForSpringConfig(SpringConfiguratorView.this.mSelectedSpringConfig);
        }

        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    }
}

