/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringConfigRegistry;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SpringChain
implements SpringListener {
    private static final SpringConfigRegistry registry = SpringConfigRegistry.getInstance();
    private static final int DEFAULT_MAIN_TENSION = 40;
    private static final int DEFAULT_MAIN_FRICTION = 6;
    private static final int DEFAULT_ATTACHMENT_TENSION = 70;
    private static final int DEFAULT_ATTACHMENT_FRICTION = 10;
    private static int id = 0;
    private final SpringSystem mSpringSystem = SpringSystem.create();
    private final CopyOnWriteArrayList<SpringListener> mListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Spring> mSprings = new CopyOnWriteArrayList();
    private int mControlSpringIndex = -1;
    private final SpringConfig mMainSpringConfig;
    private final SpringConfig mAttachmentSpringConfig;

    public static SpringChain create() {
        return new SpringChain();
    }

    public static SpringChain create(int mainTension, int mainFriction, int attachmentTension, int attachmentFriction) {
        return new SpringChain(mainTension, mainFriction, attachmentTension, attachmentFriction);
    }

    private SpringChain() {
        this(40, 6, 70, 10);
    }

    private SpringChain(int mainTension, int mainFriction, int attachmentTension, int attachmentFriction) {
        this.mMainSpringConfig = SpringConfig.fromOrigamiTensionAndFriction(mainTension, mainFriction);
        this.mAttachmentSpringConfig = SpringConfig.fromOrigamiTensionAndFriction(attachmentTension, attachmentFriction);
        registry.addSpringConfig(this.mMainSpringConfig, "main spring " + id++);
        registry.addSpringConfig(this.mAttachmentSpringConfig, "attachment spring " + id++);
    }

    public SpringConfig getMainSpringConfig() {
        return this.mMainSpringConfig;
    }

    public SpringConfig getAttachmentSpringConfig() {
        return this.mAttachmentSpringConfig;
    }

    public SpringChain addSpring(SpringListener listener) {
        Spring spring = this.mSpringSystem.createSpring().addListener(this).setSpringConfig(this.mAttachmentSpringConfig);
        this.mSprings.add(spring);
        this.mListeners.add(listener);
        return this;
    }

    public SpringChain setControlSpringIndex(int i) {
        this.mControlSpringIndex = i;
        Spring controlSpring = this.mSprings.get(this.mControlSpringIndex);
        if (controlSpring == null) {
            return null;
        }
        for (Spring spring : this.mSpringSystem.getAllSprings()) {
            spring.setSpringConfig(this.mAttachmentSpringConfig);
        }
        this.getControlSpring().setSpringConfig(this.mMainSpringConfig);
        return this;
    }

    public Spring getControlSpring() {
        return this.mSprings.get(this.mControlSpringIndex);
    }

    public List<Spring> getAllSprings() {
        return this.mSprings;
    }

    @Override
    public void onSpringUpdate(Spring spring) {
        int idx = this.mSprings.indexOf(spring);
        SpringListener listener = this.mListeners.get(idx);
        int above = -1;
        int below = -1;
        if (idx == this.mControlSpringIndex) {
            below = idx - 1;
            above = idx + 1;
        } else if (idx < this.mControlSpringIndex) {
            below = idx - 1;
        } else if (idx > this.mControlSpringIndex) {
            above = idx + 1;
        }
        if (above > -1 && above < this.mSprings.size()) {
            this.mSprings.get(above).setEndValue(spring.getCurrentValue());
        }
        if (below > -1 && below < this.mSprings.size()) {
            this.mSprings.get(below).setEndValue(spring.getCurrentValue());
        }
        listener.onSpringUpdate(spring);
    }

    @Override
    public void onSpringAtRest(Spring spring) {
        int idx = this.mSprings.indexOf(spring);
        this.mListeners.get(idx).onSpringAtRest(spring);
    }

    @Override
    public void onSpringActivate(Spring spring) {
        int idx = this.mSprings.indexOf(spring);
        this.mListeners.get(idx).onSpringActivate(spring);
    }

    @Override
    public void onSpringEndStateChange(Spring spring) {
        int idx = this.mSprings.indexOf(spring);
        this.mListeners.get(idx).onSpringEndStateChange(spring);
    }
}

