/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringLooper;
import io.intercom.com.facebook.rebound.SpringSystemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class BaseSpringSystem {
    private final Map<String, Spring> mSpringRegistry = new HashMap<String, Spring>();
    private final Set<Spring> mActiveSprings = new CopyOnWriteArraySet<Spring>();
    private final SpringLooper mSpringLooper;
    private final CopyOnWriteArraySet<SpringSystemListener> mListeners = new CopyOnWriteArraySet();
    private boolean mIdle = true;

    public BaseSpringSystem(SpringLooper springLooper) {
        if (springLooper == null) {
            throw new IllegalArgumentException("springLooper is required");
        }
        this.mSpringLooper = springLooper;
        this.mSpringLooper.setSpringSystem(this);
    }

    public boolean getIsIdle() {
        return this.mIdle;
    }

    public Spring createSpring() {
        Spring spring = new Spring(this);
        this.registerSpring(spring);
        return spring;
    }

    public Spring getSpringById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is required");
        }
        return this.mSpringRegistry.get(id);
    }

    public List<Spring> getAllSprings() {
        Collection<Spring> collection = this.mSpringRegistry.values();
        ArrayList<Spring> list = collection instanceof List ? (ArrayList<Spring>)collection : new ArrayList<Spring>(collection);
        return Collections.unmodifiableList(list);
    }

    void registerSpring(Spring spring) {
        if (spring == null) {
            throw new IllegalArgumentException("spring is required");
        }
        if (this.mSpringRegistry.containsKey(spring.getId())) {
            throw new IllegalArgumentException("spring is already registered");
        }
        this.mSpringRegistry.put(spring.getId(), spring);
    }

    void deregisterSpring(Spring spring) {
        if (spring == null) {
            throw new IllegalArgumentException("spring is required");
        }
        this.mActiveSprings.remove(spring);
        this.mSpringRegistry.remove(spring.getId());
    }

    void advance(double deltaTime) {
        for (Spring spring : this.mActiveSprings) {
            if (spring.systemShouldAdvance()) {
                spring.advance(deltaTime / 1000.0);
                continue;
            }
            this.mActiveSprings.remove(spring);
        }
    }

    public void loop(double ellapsedMillis) {
        for (SpringSystemListener listener : this.mListeners) {
            listener.onBeforeIntegrate(this);
        }
        this.advance(ellapsedMillis);
        if (this.mActiveSprings.isEmpty()) {
            this.mIdle = true;
        }
        for (SpringSystemListener listener : this.mListeners) {
            listener.onAfterIntegrate(this);
        }
        if (this.mIdle) {
            this.mSpringLooper.stop();
        }
    }

    void activateSpring(String springId) {
        Spring spring = this.mSpringRegistry.get(springId);
        if (spring == null) {
            throw new IllegalArgumentException("springId " + springId + " does not reference a registered spring");
        }
        this.mActiveSprings.add(spring);
        if (this.getIsIdle()) {
            this.mIdle = false;
            this.mSpringLooper.start();
        }
    }

    public void addListener(SpringSystemListener newListener) {
        if (newListener == null) {
            throw new IllegalArgumentException("newListener is required");
        }
        this.mListeners.add(newListener);
    }

    public void removeListener(SpringSystemListener listenerToRemove) {
        if (listenerToRemove == null) {
            throw new IllegalArgumentException("listenerToRemove is required");
        }
        this.mListeners.remove(listenerToRemove);
    }

    public void removeAllListeners() {
        this.mListeners.clear();
    }
}

