/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Choreographer;
import io.intercom.com.facebook.rebound.SpringLooper;

abstract class AndroidSpringLooperFactory {
    AndroidSpringLooperFactory() {
    }

    public static SpringLooper createSpringLooper() {
        if (Build.VERSION.SDK_INT >= 16) {
            return ChoreographerAndroidSpringLooper.create();
        }
        return LegacyAndroidSpringLooper.create();
    }

    @TargetApi(value=16)
    private static class ChoreographerAndroidSpringLooper
    extends SpringLooper {
        private final Choreographer mChoreographer;
        private final Choreographer.FrameCallback mFrameCallback;
        private boolean mStarted;
        private long mLastTime;

        public static ChoreographerAndroidSpringLooper create() {
            return new ChoreographerAndroidSpringLooper(Choreographer.getInstance());
        }

        public ChoreographerAndroidSpringLooper(Choreographer choreographer) {
            this.mChoreographer = choreographer;
            this.mFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    if (!ChoreographerAndroidSpringLooper.this.mStarted || ChoreographerAndroidSpringLooper.this.mSpringSystem == null) {
                        return;
                    }
                    long currentTime = SystemClock.uptimeMillis();
                    ChoreographerAndroidSpringLooper.this.mSpringSystem.loop(currentTime - ChoreographerAndroidSpringLooper.this.mLastTime);
                    ChoreographerAndroidSpringLooper.this.mLastTime = currentTime;
                    ChoreographerAndroidSpringLooper.this.mChoreographer.postFrameCallback(ChoreographerAndroidSpringLooper.this.mFrameCallback);
                }
            };
        }

        @Override
        public void start() {
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            this.mLastTime = SystemClock.uptimeMillis();
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            this.mChoreographer.postFrameCallback(this.mFrameCallback);
        }

        @Override
        public void stop() {
            this.mStarted = false;
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
        }
    }

    private static class LegacyAndroidSpringLooper
    extends SpringLooper {
        private final Handler mHandler;
        private final Runnable mLooperRunnable;
        private boolean mStarted;
        private long mLastTime;

        public static SpringLooper create() {
            return new LegacyAndroidSpringLooper(new Handler());
        }

        public LegacyAndroidSpringLooper(Handler handler) {
            this.mHandler = handler;
            this.mLooperRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!LegacyAndroidSpringLooper.this.mStarted || LegacyAndroidSpringLooper.this.mSpringSystem == null) {
                        return;
                    }
                    long currentTime = SystemClock.uptimeMillis();
                    LegacyAndroidSpringLooper.this.mSpringSystem.loop(currentTime - LegacyAndroidSpringLooper.this.mLastTime);
                    LegacyAndroidSpringLooper.this.mLastTime = currentTime;
                    LegacyAndroidSpringLooper.this.mHandler.post(LegacyAndroidSpringLooper.this.mLooperRunnable);
                }
            };
        }

        @Override
        public void start() {
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            this.mLastTime = SystemClock.uptimeMillis();
            this.mHandler.removeCallbacks(this.mLooperRunnable);
            this.mHandler.post(this.mLooperRunnable);
        }

        @Override
        public void stop() {
            this.mStarted = false;
            this.mHandler.removeCallbacks(this.mLooperRunnable);
        }
    }
}

