/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.content.Context;
import android.net.Uri;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.model.AssetUriParser;
import io.intercom.com.bumptech.glide.load.model.GlideUrl;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;

public abstract class UriLoader<T>
implements ModelLoader<Uri, T> {
    private final Context context;
    private final ModelLoader<GlideUrl, T> urlLoader;

    public UriLoader(Context context, ModelLoader<GlideUrl, T> urlLoader) {
        this.context = context;
        this.urlLoader = urlLoader;
    }

    @Override
    public final DataFetcher<T> getResourceFetcher(Uri model, int width, int height) {
        String scheme = model.getScheme();
        DataFetcher<T> result = null;
        if (UriLoader.isLocalUri(scheme)) {
            if (AssetUriParser.isAssetUri(model)) {
                String path = AssetUriParser.toAssetPath(model);
                result = this.getAssetPathFetcher(this.context, path);
            } else {
                result = this.getLocalUriFetcher(this.context, model);
            }
        } else if (this.urlLoader != null && ("http".equals(scheme) || "https".equals(scheme))) {
            result = this.urlLoader.getResourceFetcher(new GlideUrl(model.toString()), width, height);
        }
        return result;
    }

    protected abstract DataFetcher<T> getLocalUriFetcher(Context var1, Uri var2);

    protected abstract DataFetcher<T> getAssetPathFetcher(Context var1, String var2);

    private static boolean isLocalUri(String scheme) {
        return "file".equals(scheme) || "content".equals(scheme) || "android.resource".equals(scheme);
    }
}

