/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.view.animation.Animation;
import android.widget.ImageView;
import io.intercom.com.bumptech.glide.BitmapOptions;
import io.intercom.com.bumptech.glide.DrawableOptions;
import io.intercom.com.bumptech.glide.GenericRequestBuilder;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DecodeFormat;
import io.intercom.com.bumptech.glide.load.Encoder;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.ResourceEncoder;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.model.ImageVideoWrapper;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import io.intercom.com.bumptech.glide.load.resource.bitmap.Downsampler;
import io.intercom.com.bumptech.glide.load.resource.bitmap.FileDescriptorBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.ImageVideoBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.StreamBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.file.FileToStreamDecoder;
import io.intercom.com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import io.intercom.com.bumptech.glide.provider.LoadProvider;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.animation.BitmapCrossFadeFactory;
import io.intercom.com.bumptech.glide.request.animation.DrawableCrossFadeFactory;
import io.intercom.com.bumptech.glide.request.animation.GlideAnimationFactory;
import io.intercom.com.bumptech.glide.request.animation.ViewPropertyAnimation;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.File;
import java.io.InputStream;

public class BitmapRequestBuilder<ModelType, TranscodeType>
extends GenericRequestBuilder<ModelType, ImageVideoWrapper, Bitmap, TranscodeType>
implements BitmapOptions,
DrawableOptions {
    private final BitmapPool bitmapPool;
    private Downsampler downsampler = Downsampler.AT_LEAST;
    private DecodeFormat decodeFormat;
    private ResourceDecoder<InputStream, Bitmap> imageDecoder;
    private ResourceDecoder<ParcelFileDescriptor, Bitmap> videoDecoder;

    BitmapRequestBuilder(LoadProvider<ModelType, ImageVideoWrapper, Bitmap, TranscodeType> loadProvider, Class<TranscodeType> transcodeClass, GenericRequestBuilder<ModelType, ?, ?, ?> other) {
        super(loadProvider, transcodeClass, other);
        this.bitmapPool = other.glide.getBitmapPool();
        this.decodeFormat = other.glide.getDecodeFormat();
        this.imageDecoder = new StreamBitmapDecoder(this.bitmapPool, this.decodeFormat);
        this.videoDecoder = new FileDescriptorBitmapDecoder(this.bitmapPool, this.decodeFormat);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> approximate() {
        return this.downsample(Downsampler.AT_LEAST);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> asIs() {
        return this.downsample(Downsampler.NONE);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> atMost() {
        return this.downsample(Downsampler.AT_MOST);
    }

    private BitmapRequestBuilder<ModelType, TranscodeType> downsample(Downsampler downsampler) {
        this.downsampler = downsampler;
        this.imageDecoder = new StreamBitmapDecoder(downsampler, this.bitmapPool, this.decodeFormat);
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, this.videoDecoder));
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(float sizeMultiplier) {
        super.thumbnail(sizeMultiplier);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(BitmapRequestBuilder<?, TranscodeType> thumbnailRequest) {
        super.thumbnail(thumbnailRequest);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> sizeMultiplier(float sizeMultiplier) {
        super.sizeMultiplier(sizeMultiplier);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> decoder(ResourceDecoder<ImageVideoWrapper, Bitmap> decoder) {
        super.decoder(decoder);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> cacheDecoder(ResourceDecoder<File, Bitmap> cacheDecoder) {
        super.cacheDecoder(cacheDecoder);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> encoder(ResourceEncoder<Bitmap> encoder) {
        super.encoder(encoder);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> imageDecoder(ResourceDecoder<InputStream, Bitmap> decoder) {
        this.imageDecoder = decoder;
        super.decoder(new ImageVideoBitmapDecoder(decoder, this.videoDecoder));
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> videoDecoder(ResourceDecoder<ParcelFileDescriptor, Bitmap> decoder) {
        this.videoDecoder = decoder;
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, decoder));
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> format(DecodeFormat format) {
        this.decodeFormat = format;
        this.imageDecoder = new StreamBitmapDecoder(this.downsampler, this.bitmapPool, format);
        this.videoDecoder = new FileDescriptorBitmapDecoder(new VideoBitmapDecoder(), this.bitmapPool, format);
        super.cacheDecoder(new FileToStreamDecoder<Bitmap>(new StreamBitmapDecoder(this.downsampler, this.bitmapPool, format)));
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, this.videoDecoder));
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> priority(Priority priority) {
        super.priority(priority);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> transform(BitmapTransformation ... transformations) {
        super.transform(transformations);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> centerCrop() {
        return this.transform(new BitmapTransformation[]{this.glide.getBitmapCenterCrop()});
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> fitCenter() {
        return this.transform(new BitmapTransformation[]{this.glide.getBitmapFitCenter()});
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> transform(Transformation<Bitmap> ... transformations) {
        super.transform(transformations);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> transcoder(ResourceTranscoder<Bitmap, TranscodeType> transcoder) {
        super.transcoder(transcoder);
        return this;
    }

    private RuntimeException crossFadeNotSupported() {
        String className = this.transcodeClass.getCanonicalName();
        if (className == null) {
            className = this.transcodeClass.toString();
        }
        return new UnsupportedOperationException(".crossFade() is not supported for " + className + ", use .animate() to provide a compatible animation.");
    }

    public final BitmapRequestBuilder<ModelType, TranscodeType> crossFade() {
        if (Bitmap.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new BitmapCrossFadeFactory());
        }
        if (Drawable.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new DrawableCrossFadeFactory());
        }
        throw this.crossFadeNotSupported();
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> crossFade(int duration) {
        if (Bitmap.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new BitmapCrossFadeFactory(duration));
        }
        if (Drawable.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new DrawableCrossFadeFactory(duration));
        }
        throw this.crossFadeNotSupported();
    }

    @Deprecated
    public BitmapRequestBuilder<ModelType, TranscodeType> crossFade(Animation animation, int duration) {
        if (Bitmap.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new BitmapCrossFadeFactory(animation, duration));
        }
        if (Drawable.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new DrawableCrossFadeFactory(animation, duration));
        }
        throw this.crossFadeNotSupported();
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> crossFade(int animationId, int duration) {
        if (Bitmap.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new BitmapCrossFadeFactory(this.context, animationId, duration));
        }
        if (Drawable.class.isAssignableFrom(this.transcodeClass)) {
            return this.animate((GlideAnimationFactory)new DrawableCrossFadeFactory(this.context, animationId, duration));
        }
        throw this.crossFadeNotSupported();
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> dontAnimate() {
        super.dontAnimate();
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> animate(int animationId) {
        super.animate(animationId);
        return this;
    }

    @Deprecated
    public BitmapRequestBuilder<ModelType, TranscodeType> animate(Animation animation) {
        super.animate(animation);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> animate(ViewPropertyAnimation.Animator animator) {
        super.animate(animator);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> animate(GlideAnimationFactory<TranscodeType> animationFactory) {
        super.animate(animationFactory);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> placeholder(int resourceId) {
        super.placeholder(resourceId);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> placeholder(Drawable drawable2) {
        super.placeholder(drawable2);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> fallback(Drawable drawable2) {
        super.fallback(drawable2);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> fallback(int resourceId) {
        super.fallback(resourceId);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> error(int resourceId) {
        super.error(resourceId);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> error(Drawable drawable2) {
        super.error(drawable2);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> listener(RequestListener<? super ModelType, TranscodeType> requestListener) {
        super.listener(requestListener);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> skipMemoryCache(boolean skip) {
        super.skipMemoryCache(skip);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> diskCacheStrategy(DiskCacheStrategy strategy) {
        super.diskCacheStrategy(strategy);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> override(int width, int height) {
        super.override(width, height);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(GenericRequestBuilder<?, ?, ?, TranscodeType> thumbnailRequest) {
        super.thumbnail(thumbnailRequest);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> sourceEncoder(Encoder<ImageVideoWrapper> sourceEncoder) {
        super.sourceEncoder(sourceEncoder);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> dontTransform() {
        super.dontTransform();
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> signature(Key signature) {
        super.signature(signature);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> load(ModelType model) {
        super.load(model);
        return this;
    }

    @Override
    public BitmapRequestBuilder<ModelType, TranscodeType> clone() {
        return (BitmapRequestBuilder)super.clone();
    }

    @Override
    public Target<TranscodeType> into(ImageView view) {
        return super.into(view);
    }

    @Override
    void applyFitCenter() {
        this.fitCenter();
    }

    @Override
    void applyCenterCrop() {
        this.centerCrop();
    }
}

