/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.LinkOpener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class IntercomLinkView
extends TextView {
    private static final int INTERCOM_LINK_ANIMATION_TIME_MS = 100;
    private final int conversationBottomPaddingPx;
    private final int[] lastChildPosition = new int[2];
    private final int[] intercomLinkPosition = new int[2];
    private int lastBottomPosition = 0;

    public IntercomLinkView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.conversationBottomPaddingPx = ScreenUtils.convertDpToPixel((float)8.0f, (Context)this.getContext());
    }

    public void followIntercomLink(AppIdentity appIdentity, Part firstPart, Api api) {
        LinkOpener.handleUrl(this.createIntercomLinkUrl(appIdentity, firstPart), this.getContext(), api);
    }

    String createIntercomLinkUrl(AppIdentity appIdentity, Part firstPart) {
        StringBuilder intercomLinkUrl = new StringBuilder(162).append("http://www.intercom.io/intercom-link?company=");
        try {
            intercomLinkUrl.append(URLEncoder.encode(appIdentity.getAppConfig().getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            IntercomLogger.i("Could not url encode the app name");
        }
        if (Part.NULL == firstPart || firstPart.isUser()) {
            intercomLinkUrl.append("&product=support");
        } else if ("chat".equals(firstPart.getMessageStyle())) {
            intercomLinkUrl.append("&product=learn");
        } else {
            intercomLinkUrl.append("&product=engage");
        }
        intercomLinkUrl.append("&utm_source=android-sdk&utm_campaign=intercom-link&utm_content=we-run-on-intercom&utm_medium=messenger");
        return intercomLinkUrl.toString();
    }

    public void intersectsView(View lastChild) {
        lastChild.getLocationOnScreen(this.lastChildPosition);
        int bottomOfLastElement = this.lastChildPosition[1] + lastChild.getHeight() + this.conversationBottomPaddingPx;
        this.getLocationOnScreen(this.intercomLinkPosition);
        if (bottomOfLastElement >= this.intercomLinkPosition[1] && this.lastBottomPosition < this.intercomLinkPosition[1]) {
            this.hide();
        } else if (bottomOfLastElement < this.intercomLinkPosition[1] && this.lastBottomPosition >= this.intercomLinkPosition[1]) {
            this.show();
        }
        this.lastBottomPosition = bottomOfLastElement;
    }

    public void show() {
        this.animate().alpha(1.0f).setDuration(100L);
    }

    public void hide() {
        this.animate().alpha(0.0f).setDuration(100L);
    }
}

