/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.utilities.LinkOpener;
import io.intercom.android.sdk.utilities.TimeProvider;

public class TrackingLinkMovementMethod
extends LinkMovementMethod {
    private boolean longClickActive = false;
    private boolean longClickPerformed = false;
    private long startClickTime;

    public boolean onTouchEvent(TextView textView, Spannable buffer, MotionEvent event) {
        boolean consume = false;
        int position = this.getPosition(event, textView);
        URLSpan[] link = (URLSpan[])buffer.getSpans(position, position, URLSpan.class);
        switch (event.getAction()) {
            case 0: {
                this.startClickTime = TimeProvider.SYSTEM.currentTimeMillis();
                if (!this.longClickActive) {
                    this.longClickActive = true;
                }
                if (link.length == 0) break;
                Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                break;
            }
            case 1: {
                this.longClickActive = false;
                if (!this.longClickPerformed) {
                    if (link.length != 0) {
                        String url = link[0].getURL();
                        LinkOpener.handleUrl(url, textView.getContext(), Injector.get().getApi());
                    } else {
                        Selection.removeSelection((Spannable)buffer);
                        this.performClick((ViewGroup)textView.getParent());
                    }
                    consume = true;
                }
                this.longClickPerformed = false;
                break;
            }
            case 2: {
                long clickDuration;
                if (!this.longClickActive || (clickDuration = TimeProvider.SYSTEM.currentTimeMillis() - this.startClickTime) < (long)ViewConfiguration.getLongPressTimeout()) break;
                this.longClickActive = false;
                this.performLongClick((ViewGroup)textView.getParent());
                consume = true;
                this.longClickPerformed = true;
                break;
            }
        }
        return consume;
    }

    private void performClick(ViewGroup viewGroup) {
        while (!viewGroup.performClick()) {
            ViewParent viewParent = viewGroup.getParent();
            if (viewParent instanceof ViewGroup) {
                viewGroup = (ViewGroup)viewGroup.getParent();
                continue;
            }
            return;
        }
    }

    private void performLongClick(ViewGroup viewGroup) {
        while (!viewGroup.performLongClick()) {
            ViewParent viewParent = viewGroup.getParent();
            if (viewParent instanceof ViewGroup) {
                viewGroup = (ViewGroup)viewGroup.getParent();
                continue;
            }
            return;
        }
    }

    private int getPosition(MotionEvent event, TextView textView) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= textView.getTotalPaddingLeft();
        y -= textView.getTotalPaddingTop();
        Layout layout2 = textView.getLayout();
        int line = layout2.getLineForVertical(y += textView.getScrollY());
        return layout2.getOffsetForHorizontal(line, (float)(x += textView.getScrollX()));
    }
}

