/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.utilities.ConnectivityBroadcastReceiver;
import io.intercom.android.sdk.utilities.NetworkState;
import java.util.HashMap;

public class NetworkConnectivityListener
implements ConnectivityBroadcastReceiver.ConnectivityUpdateListener {
    @Nullable
    private Context context;
    @NonNull
    private final HashMap<Handler, Integer> handlers = new HashMap();
    @NonNull
    private final ConnectivityBroadcastReceiver receiver = new ConnectivityBroadcastReceiver(this);

    @Override
    public void onUpdate() {
        for (Handler target : this.handlers.keySet()) {
            Message message = Message.obtain((Handler)target, (int)this.handlers.get(target));
            target.sendMessage(message);
        }
    }

    public synchronized void startListening(Context context) {
        if (!this.receiver.isListening()) {
            this.context = context;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this.receiver, filter);
            this.receiver.setListening(true);
        }
    }

    public synchronized void stopListening() {
        if (this.receiver.isListening()) {
            if (this.context != null) {
                this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
            }
            this.context = null;
            this.receiver.setListening(false);
        }
    }

    public void registerHandler(Handler target, int what) {
        this.handlers.put(target, what);
    }

    public void unregisterHandler(Handler target) {
        this.handlers.remove(target);
    }

    @NonNull
    public NetworkState getState() {
        return this.receiver.getState();
    }

    @NonNull
    @VisibleForTesting
    public HashMap<Handler, Integer> getHandlers() {
        return this.handlers;
    }

    @Nullable
    @VisibleForTesting
    public Context getContext() {
        return this.context;
    }
}

