/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.ChatFull;
import io.intercom.android.sdk.preview.ChatSnippet;
import io.intercom.android.sdk.preview.DefaultLauncher;
import io.intercom.android.sdk.preview.Overlay;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.preview.PreviewInteractionManager;
import io.intercom.android.sdk.preview.StackableSnippet;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.facebook.rebound.BaseSpringSystem;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class NotificationManager
implements PreviewCallbacks,
View.OnClickListener {
    public static final int MAX_DISPLAYED_NOTIFICATIONS = 3;
    private final PreviewInteractionManager interactionManager;
    private final LayoutInflater inflater;
    private final Map<String, Overlay> notifications = new HashMap<String, Overlay>();
    private final List<Conversation> lastDisplayedConversations = new ArrayList<Conversation>();
    private final Handler handler;
    private final MetricsStore.Provider metricsStoreProvider;
    private boolean hasAnimated = false;
    private boolean isStackForm = false;

    public NotificationManager(LayoutInflater inflater, Handler handler, PreviewInteractionManager interactionManager, MetricsStore.Provider metricsStoreProvider) {
        this.inflater = inflater;
        this.interactionManager = interactionManager;
        this.handler = handler;
        this.metricsStoreProvider = metricsStoreProvider;
    }

    public void displayNotificationsWithLauncherAnimation(final ViewGroup root, final List<Conversation> conversations, final DefaultLauncher defaultLauncher) {
        if (conversations.size() == 1) {
            defaultLauncher.pulseForTransformation(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    defaultLauncher.fadeOffScreen(new SimpleAnimatorListener(){

                        @Override
                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                        }
                    });
                    NotificationManager.this.displayNotifications(root, conversations);
                }
            });
        } else {
            defaultLauncher.fadeOffScreen(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    defaultLauncher.removeView();
                    NotificationManager.this.displayNotifications(root, conversations);
                }
            });
        }
    }

    public void displayNotifications(final ViewGroup root, final List<Conversation> conversations) {
        final boolean hasChanged = !this.lastDisplayedConversations.equals(conversations) && !this.notifications.isEmpty();
        final HashMap<String, Overlay> tempNotifications = new HashMap<String, Overlay>(this.notifications);
        if (conversations.size() > 1) {
            this.isStackForm = true;
        }
        ViewUtils.waitForViewAttachment((View)root, new Runnable(){

            @Override
            public void run() {
                NotificationManager.this.displayPreviews(conversations, tempNotifications, root, hasChanged);
            }
        });
    }

    public boolean isDisplaying() {
        return !this.notifications.isEmpty();
    }

    public void reset() {
        this.notifications.clear();
    }

    @Override
    public void onSnippetTap(Conversation conversation) {
        this.interactionManager.openNotification(conversation);
    }

    @Override
    public void onSnippetDismiss(Overlay notificationOverlay) {
        Part lastPart;
        ViewGroup rootView = null;
        try {
            rootView = this.interactionManager.getRootView();
        }
        catch (Exception e) {
            IntercomLogger.internal("Couldn't get root view: " + e.getMessage());
        }
        Conversation conversation = notificationOverlay.getConversation();
        if (rootView != null) {
            this.interactionManager.markAsDismissed(conversation);
            rootView.removeView(notificationOverlay.getRootView());
            this.notifications.remove(conversation.getId());
            this.lastDisplayedConversations.remove(conversation);
            for (Overlay overlay : this.notifications.values()) {
                overlay.moveForward(rootView, this.inflater);
            }
            this.displayPill(this.inflater, rootView);
            if (this.notifications.isEmpty()) {
                this.hasAnimated = false;
                this.isStackForm = false;
            }
        }
        if ("chat".equals((lastPart = conversation.getLastAdminPart()).getMessageStyle()) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
            this.metricsStoreProvider.getMetricsStore().track(MetricFactory.closedInAppFromFull(conversation.getId(), lastPart.getId()));
        } else if (lastPart.isInitialMessage()) {
            this.metricsStoreProvider.getMetricsStore().track(MetricFactory.dismissInAppMessageSnippet(conversation.getId(), lastPart.getId()));
        } else {
            this.metricsStoreProvider.getMetricsStore().track(MetricFactory.dismissInAppCommentSnippet(conversation.getId(), lastPart.getId()));
        }
    }

    public void onClick(View view) {
        Intent iamInboxIntent = IntercomMessengerActivity.openInbox(view.getContext());
        view.getContext().startActivity(iamInboxIntent);
    }

    private void displayPreviews(List<Conversation> conversations, Map<String, Overlay> temp, ViewGroup root, boolean hasDifferentConversations) {
        if (hasDifferentConversations) {
            this.updateNotifications(conversations, temp, root);
        } else if (!this.isDisplaying()) {
            this.addNewNotifications(conversations, root);
        }
        this.hasAnimated = true;
        this.displayPill(this.inflater, root);
        this.lastDisplayedConversations.clear();
        this.lastDisplayedConversations.addAll(conversations);
    }

    private void addNewNotifications(List<Conversation> conversations, ViewGroup root) {
        int count = conversations.size();
        for (int i = 0; i < count; ++i) {
            Conversation conversation = conversations.get(i);
            Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
            BaseSpringSystem springSystem = this.getSpringSystem();
            Overlay overlay = !this.isStackForm && "chat".equals(conversation.getLastPart().getMessageStyle()) ? (conversation.getLastPart().getDeliveryOption() == Part.DeliveryOption.SUMMARY ? new ChatSnippet(localisedContext, conversation, i, springSystem, root.getHeight(), this) : new ChatFull(localisedContext, conversation, i, springSystem, root.getHeight(), this)) : new StackableSnippet(localisedContext, conversation, i, springSystem, this.handler, root.getHeight(), this);
            this.notifications.put(conversation.getId(), overlay);
            if (i >= 3) continue;
            overlay.display(root, this.inflater, !this.hasAnimated);
        }
    }

    private void updateNotifications(final List<Conversation> conversations, final Map<String, Overlay> temp, final ViewGroup root) {
        final Conversation conversation = conversations.get(0);
        Iterator<Overlay> iterator = temp.values().iterator();
        Overlay firstOverlay = iterator.next();
        while (iterator.hasNext()) {
            Overlay p = iterator.next();
            if (p.getPosition() >= firstOverlay.getPosition()) continue;
            firstOverlay = p;
        }
        if (this.isReply(conversation)) {
            firstOverlay.update(conversation, new Runnable(){

                @Override
                public void run() {
                    NotificationManager.this.syncUpdates(conversations, temp, root);
                }
            });
        } else if (temp.size() == 1 && firstOverlay instanceof ChatSnippet) {
            firstOverlay.moveBackward(root, new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    NotificationManager.this.addNewView(conversation, root, temp);
                    NotificationManager.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            NotificationManager.this.syncUpdates(conversations, temp, root);
                        }
                    }, 220L);
                }
            });
        } else {
            for (Overlay overlay : temp.values()) {
                if (overlay.getPosition() < 3) {
                    overlay.moveBackward(root);
                    continue;
                }
                overlay.setPosition(overlay.getPosition() + 1);
            }
            this.addNewView(conversation, root, temp);
            this.syncUpdates(conversations, temp, root);
        }
    }

    private void addNewView(Conversation conversation, ViewGroup root, Map<String, Overlay> temp) {
        Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
        StackableSnippet notification = new StackableSnippet(localisedContext, conversation, 0, this.getSpringSystem(), this.handler, root.getHeight(), this);
        ((Overlay)notification).display(root, this.inflater, true);
        if (temp.containsKey(conversation.getId())) {
            temp.get(conversation.getId()).removeView();
        }
        temp.put(conversation.getId(), notification);
    }

    private BaseSpringSystem getSpringSystem() {
        return Injector.get().getSpringProvider().newSpringSystem();
    }

    private void syncUpdates(List<Conversation> conversations, Map<String, Overlay> temp, ViewGroup root) {
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation tempConversation = conversations.get(i);
            Overlay overlay = temp.remove(tempConversation.getId());
            if (overlay instanceof ChatSnippet && i > 0 || overlay == null) {
                if (overlay != null) {
                    overlay.removeView();
                }
                Context localisedContext = ContextLocaliser.create().createLocalisedContext(root.getContext());
                overlay = new StackableSnippet(localisedContext, tempConversation, i, this.getSpringSystem(), this.handler, root.getHeight(), this);
            }
            if (i < 3) {
                overlay.display(root, tempConversation, this.inflater, false);
            } else {
                overlay.removeView();
            }
            this.notifications.put(tempConversation.getId(), overlay);
        }
        for (Overlay overlay : temp.values()) {
            overlay.removeView();
        }
    }

    private void displayPill(LayoutInflater inflater, ViewGroup root) {
        TextView pill = (TextView)root.findViewById(R.id.preview_pill);
        if (this.notifications.size() <= 3) {
            if (pill != null) {
                root.removeView((View)pill);
            }
        } else {
            if (pill == null) {
                inflater.inflate(R.layout.intercom_notification_pill, root, true);
                pill = (TextView)root.findViewById(R.id.preview_pill);
                pill.setAlpha(0.0f);
                pill.setScaleX(0.4f);
                pill.setScaleY(0.4f);
                pill.setOnClickListener((View.OnClickListener)this);
                this.animatePill((View)pill);
            }
            Context localised = ContextLocaliser.create().createLocalisedContext(pill.getContext());
            CharSequence pillString = Phrase.from(localised, R.string.intercom_pill_display_text).put("n", this.notifications.size() - 3).format();
            pill.setText(pillString);
        }
    }

    private void animatePill(final View view) {
        SpringConfig springConfig = new SpringConfig(400.0, 24.0);
        final Spring spring = this.getSpringSystem().createSpring();
        spring.setSpringConfig(springConfig);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                final float initialY = view.getY();
                spring.setCurrentValue((double)(view.getY() + 200.0f));
                spring.setEndValue((double)view.getY());
                spring.addListener((SpringListener)new SimpleSpringListener(){

                    public void onSpringUpdate(Spring spring) {
                        super.onSpringUpdate(spring);
                        double current = spring.getCurrentValue();
                        view.setY((float)current);
                        view.setAlpha((float)SpringUtil.mapValueFromRangeToRange((double)current, (double)(initialY + 200.0f), (double)initialY, (double)0.0, (double)1.0));
                        double scale = SpringUtil.mapValueFromRangeToRange((double)current, (double)(initialY + 200.0f), (double)initialY, (double)0.4, (double)1.0);
                        view.setScaleX((float)scale);
                        view.setScaleY((float)scale);
                    }
                });
            }
        }, 500L);
    }

    public boolean isReply(Conversation conversation) {
        return !this.lastDisplayedConversations.isEmpty() && conversation.getId().equals(this.lastDisplayedConversations.get(0).getId());
    }
}

