/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.Nullable;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.retrofit2.Response;
import java.io.IOException;

class ErrorObject {
    private final Throwable throwable;
    private final int statusCode;
    @Nullable
    private final String errorBody;

    ErrorObject(Throwable throwable, @Nullable Response response) {
        this.throwable = throwable;
        this.errorBody = this.parseErrorBody(response);
        this.statusCode = this.parseStatusCode(response);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    String getErrorBody() {
        return this.errorBody;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    boolean hasErrorBody() {
        return this.errorBody != null;
    }

    private int parseStatusCode(@Nullable Response response) {
        if (response != null) {
            return response.code();
        }
        return -1;
    }

    private String parseErrorBody(@Nullable Response response) {
        if (response != null) {
            try {
                return response.errorBody().string();
            }
            catch (IOException e) {
                IntercomLogger.internal("Couldn't parse error body: " + e.getMessage());
            }
        }
        return null;
    }
}

