/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class PartViewHolder
extends BlocksPartViewHolder {
    private final int viewType;
    private final TextView time;
    private final PartMetadataFormatter partMetadataFormatter;
    private ViewGroup blocks;

    public PartViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, PartMetadataFormatter partMetadataFormatter) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.partMetadataFormatter = partMetadataFormatter;
        this.time = (TextView)itemView.findViewById(R.id.rowTime);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        boolean shouldConcatenate = this.shouldConcatenate(part, this.getAdapterPosition());
        this.blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        this.setupHolderBackground(this.viewType, part, shouldConcatenate);
        this.setupMetaData(this.viewType, part);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, this.cellLayout, this.blocks);
        if (this.bubble != null) {
            this.bubble.setExpanded(this.shouldExpand(part), false);
        }
    }

    private boolean shouldExpand(Part part) {
        return this.isSelectedPart(part) || this.isLastPart(part) || this.isNextPartTyping(this.getAdapterPosition() + 1);
    }

    @VisibleForTesting
    public boolean isSelectedPart(Part part) {
        return part == this.conversationListener.getSelectedPart();
    }

    @VisibleForTesting
    public boolean isLastPart(Part part) {
        return part == this.conversationListener.getPart(this.conversationListener.getCount() - 1) && !"admin_is_typing_style".equals(part.getMessageStyle());
    }

    @VisibleForTesting
    public boolean isNextPartTyping(int nextPos) {
        return nextPos <= this.conversationListener.getCount() - 1 && "admin_is_typing_style".equals(this.conversationListener.getPart(nextPos).getMessageStyle());
    }

    private void setupHolderBackground(int type, Part conversationPart, boolean shouldConcatenate) {
        this.setBubbleBackground(conversationPart, (View)this.blocks, type);
        if (this.networkAvatar != null) {
            if (shouldConcatenate) {
                this.networkAvatar.setVisibility(4);
            } else if (type == 1 || type == 5 || type == 4) {
                this.showAvatar(conversationPart.getParticipant(), this.networkAvatar);
            }
        }
    }

    public void onClick(View v) {
        this.conversationListener.onPartClicked(this.getAdapterPosition(), this);
    }

    public void setExpanded(boolean expanded) {
        if (this.bubble != null) {
            this.bubble.setExpanded(expanded, true);
        }
    }

    private void setupMetaData(int type, Part conversationPart) {
        if (this.time == null) {
            return;
        }
        boolean isLastItem = conversationPart == this.conversationListener.getPart(this.conversationListener.getCount() - 1);
        String metadataText = this.partMetadataFormatter.getMetadataString(type, conversationPart, isLastItem);
        if (metadataText == null) {
            this.time.setVisibility(4);
            this.time.setHeight(ScreenUtils.convertDpToPixel((float)10.0f, (Context)this.time.getContext()));
        } else {
            this.time.setText((CharSequence)metadataText);
            if (Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
                this.time.setCompoundDrawablesWithIntrinsicBounds(R.drawable.intercom_message_error, 0, 0, 0);
            } else {
                this.time.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            }
        }
    }

    protected boolean shouldConcatenate(Part conversationPart, int position) {
        if (position + 1 < this.conversationListener.getCount()) {
            Part nextPart = this.conversationListener.getPart(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    protected void setBubbleBackground(Part conversationPart, View blocks, int type) {
        int pLeft = blocks.getPaddingLeft();
        int pRight = blocks.getPaddingRight();
        int pTop = blocks.getPaddingTop();
        int pBottom = blocks.getPaddingBottom();
        if (conversationPart.isImageOnly()) {
            this.cellLayout.setBackgroundColor(0);
            this.cellLayout.setPadding(0, 0, 0, 0);
            pBottom = 0;
            pTop = 0;
        } else {
            Context context = this.cellLayout.getContext();
            int cellPadding = (int)context.getResources().getDimension(R.dimen.intercom_cell_horizontal_padding);
            this.cellLayout.setPadding(cellPadding, 0, cellPadding, 0);
            Drawable bubbleBackground = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_bubble_background);
            if (!conversationPart.isAdmin() && type != 4) {
                AppConfig appConfig = Injector.get().getAppIdentity().getAppConfig();
                bubbleBackground.setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
            }
            BackgroundUtils.setBackground((View)this.cellLayout, bubbleBackground);
        }
        blocks.setPadding(pLeft, pTop, pRight, pBottom);
    }
}

