/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Gravity;
import io.intercom.com.bumptech.glide.gifdecoder.GifDecoder;
import io.intercom.com.bumptech.glide.gifdecoder.GifHeader;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.load.resource.gif.GifFrameLoader;

public class GifDrawable
extends GlideDrawable
implements GifFrameLoader.FrameCallback {
    private final Paint paint;
    private final Rect destRect = new Rect();
    private final GifState state;
    private final GifDecoder decoder;
    private final GifFrameLoader frameLoader;
    private boolean isRunning;
    private boolean isStarted;
    private boolean isRecycled;
    private boolean isVisible = true;
    private int loopCount;
    private int maxLoopCount = -1;
    private boolean applyGravity;

    public GifDrawable(Context context, GifDecoder.BitmapProvider bitmapProvider, BitmapPool bitmapPool, Transformation<Bitmap> frameTransformation, int targetFrameWidth, int targetFrameHeight, GifHeader gifHeader, byte[] data, Bitmap firstFrame) {
        this(new GifState(gifHeader, data, context, frameTransformation, targetFrameWidth, targetFrameHeight, bitmapProvider, bitmapPool, firstFrame));
    }

    public GifDrawable(GifDrawable other, Bitmap firstFrame, Transformation<Bitmap> frameTransformation) {
        this(new GifState(other.state.gifHeader, other.state.data, other.state.context, frameTransformation, other.state.targetWidth, other.state.targetHeight, other.state.bitmapProvider, other.state.bitmapPool, firstFrame));
    }

    GifDrawable(GifState state) {
        if (state == null) {
            throw new NullPointerException("GifState must not be null");
        }
        this.state = state;
        this.decoder = new GifDecoder(state.bitmapProvider);
        this.paint = new Paint();
        this.decoder.setData(state.gifHeader, state.data);
        this.frameLoader = new GifFrameLoader(state.context, this, this.decoder, state.targetWidth, state.targetHeight);
        this.frameLoader.setFrameTransformation(state.frameTransformation);
    }

    GifDrawable(GifDecoder decoder, GifFrameLoader frameLoader, Bitmap firstFrame, BitmapPool bitmapPool, Paint paint) {
        this.decoder = decoder;
        this.frameLoader = frameLoader;
        this.state = new GifState(null);
        this.paint = paint;
        this.state.bitmapPool = bitmapPool;
        this.state.firstFrame = firstFrame;
    }

    public Bitmap getFirstFrame() {
        return this.state.firstFrame;
    }

    public void setFrameTransformation(Transformation<Bitmap> frameTransformation, Bitmap firstFrame) {
        if (firstFrame == null) {
            throw new NullPointerException("The first frame of the GIF must not be null");
        }
        if (frameTransformation == null) {
            throw new NullPointerException("The frame transformation must not be null");
        }
        this.state.frameTransformation = frameTransformation;
        this.state.firstFrame = firstFrame;
        this.frameLoader.setFrameTransformation(frameTransformation);
    }

    public GifDecoder getDecoder() {
        return this.decoder;
    }

    public Transformation<Bitmap> getFrameTransformation() {
        return this.state.frameTransformation;
    }

    public byte[] getData() {
        return this.state.data;
    }

    public int getFrameCount() {
        return this.decoder.getFrameCount();
    }

    private void resetLoopCount() {
        this.loopCount = 0;
    }

    public void start() {
        this.isStarted = true;
        this.resetLoopCount();
        if (this.isVisible) {
            this.startRunning();
        }
    }

    public void stop() {
        this.isStarted = false;
        this.stopRunning();
        if (Build.VERSION.SDK_INT < 11) {
            this.reset();
        }
    }

    private void reset() {
        this.frameLoader.clear();
        this.invalidateSelf();
    }

    private void startRunning() {
        if (this.decoder.getFrameCount() == 1) {
            this.invalidateSelf();
        } else if (!this.isRunning) {
            this.isRunning = true;
            this.frameLoader.start();
            this.invalidateSelf();
        }
    }

    private void stopRunning() {
        this.isRunning = false;
        this.frameLoader.stop();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.isVisible = visible;
        if (!visible) {
            this.stopRunning();
        } else if (this.isStarted) {
            this.startRunning();
        }
        return super.setVisible(visible, restart);
    }

    public int getIntrinsicWidth() {
        return this.state.firstFrame.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.state.firstFrame.getHeight();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.applyGravity = true;
    }

    public void draw(Canvas canvas) {
        Bitmap currentFrame;
        if (this.isRecycled) {
            return;
        }
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        Bitmap toDraw = (currentFrame = this.frameLoader.getCurrentFrame()) != null ? currentFrame : this.state.firstFrame;
        canvas.drawBitmap(toDraw, null, this.destRect, this.paint);
    }

    public void setAlpha(int i) {
        this.paint.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -2;
    }

    @Override
    @TargetApi(value=11)
    public void onFrameReady(int frameIndex) {
        if (Build.VERSION.SDK_INT >= 11 && this.getCallback() == null) {
            this.stop();
            this.reset();
            return;
        }
        this.invalidateSelf();
        if (frameIndex == this.decoder.getFrameCount() - 1) {
            ++this.loopCount;
        }
        if (this.maxLoopCount != -1 && this.loopCount >= this.maxLoopCount) {
            this.stop();
        }
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    public void recycle() {
        this.isRecycled = true;
        this.state.bitmapPool.put(this.state.firstFrame);
        this.frameLoader.clear();
        this.frameLoader.stop();
    }

    boolean isRecycled() {
        return this.isRecycled;
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public void setLoopCount(int loopCount) {
        if (loopCount <= 0 && loopCount != -1 && loopCount != 0) {
            throw new IllegalArgumentException("Loop count must be greater than 0, or equal to GlideDrawable.LOOP_FOREVER, or equal to GlideDrawable.LOOP_INTRINSIC");
        }
        this.maxLoopCount = loopCount == 0 ? this.decoder.getLoopCount() : loopCount;
    }

    static class GifState
    extends Drawable.ConstantState {
        private static final int GRAVITY = 119;
        GifHeader gifHeader;
        byte[] data;
        Context context;
        Transformation<Bitmap> frameTransformation;
        int targetWidth;
        int targetHeight;
        GifDecoder.BitmapProvider bitmapProvider;
        BitmapPool bitmapPool;
        Bitmap firstFrame;

        public GifState(GifHeader header, byte[] data, Context context, Transformation<Bitmap> frameTransformation, int targetWidth, int targetHeight, GifDecoder.BitmapProvider provider, BitmapPool bitmapPool, Bitmap firstFrame) {
            if (firstFrame == null) {
                throw new NullPointerException("The first frame of the GIF must not be null");
            }
            this.gifHeader = header;
            this.data = data;
            this.bitmapPool = bitmapPool;
            this.firstFrame = firstFrame;
            this.context = context.getApplicationContext();
            this.frameTransformation = frameTransformation;
            this.targetWidth = targetWidth;
            this.targetHeight = targetHeight;
            this.bitmapProvider = provider;
        }

        public GifState(GifState original) {
            if (original != null) {
                this.gifHeader = original.gifHeader;
                this.data = original.data;
                this.context = original.context;
                this.frameTransformation = original.frameTransformation;
                this.targetWidth = original.targetWidth;
                this.targetHeight = original.targetHeight;
                this.bitmapProvider = original.bitmapProvider;
                this.bitmapPool = original.bitmapPool;
                this.firstFrame = original.firstFrame;
            }
        }

        public Drawable newDrawable(Resources res) {
            return this.newDrawable();
        }

        public Drawable newDrawable() {
            return new GifDrawable(this);
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

