/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.FontUtils;

public class IntercomErrorView
extends RelativeLayout {
    private TextView titleView;
    private TextView subtitle;
    private Button actionButton;

    public IntercomErrorView(Context context) {
        this(context, null);
    }

    public IntercomErrorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.titleView = (TextView)this.findViewById(R.id.empty_text_title);
        FontUtils.setRobotoMediumTypeface(this.titleView);
        this.subtitle = (TextView)this.findViewById(R.id.empty_text_subtitle);
        this.actionButton = (Button)this.findViewById(R.id.action_button);
    }

    public void setTitle(CharSequence title) {
        this.titleView.setText(title);
    }

    public void setTitle(@StringRes int title) {
        this.titleView.setText(title);
    }

    public void setSubtitle(CharSequence subtitle) {
        this.subtitle.setText(subtitle);
    }

    public void setSubtitle(@StringRes int subtitle) {
        this.subtitle.setText(subtitle);
    }

    public void setActionButtonVisibility(int visibility) {
        this.actionButton.setVisibility(visibility);
    }

    public void setActionButtonText(@StringRes int text) {
        this.actionButton.setText(text);
    }

    public void setActionButtonClickListener(@Nullable View.OnClickListener onClickListener) {
        this.actionButton.setOnClickListener(onClickListener);
    }

    public void setActionButtonTextColor(@ColorInt int color2) {
        this.actionButton.setTextColor(color2);
    }
}

