/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.store.Store;

class ChangeSubscriber<S, T>
implements Store.Subscriber<S> {
    private final Store.Selector<S, T> selector;
    final Store.Subscriber<T> subscriber;
    private final Handler mainHandler;
    @Nullable
    private T last = null;

    ChangeSubscriber(Store.Selector<S, T> selector, Store.Subscriber<T> subscriber) {
        this(selector, subscriber, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    ChangeSubscriber(Store.Selector<S, T> selector, Store.Subscriber<T> subscriber, Handler mainHandler) {
        this.selector = selector;
        this.subscriber = subscriber;
        this.mainHandler = mainHandler;
    }

    @Override
    public void onStateChange(S state) {
        final T current = this.selector.transform(state);
        if (this.last != current) {
            ChangeSubscriber.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ChangeSubscriber.this.subscriber.onStateChange(current);
                }
            }, this.mainHandler);
            this.last = current;
        }
    }

    static void runOnMainThread(Runnable runnable, Handler mainHandler) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            mainHandler.post(runnable);
        }
    }
}

