/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.events.CloseMessengerEvent;
import io.intercom.android.sdk.overlay.OverlayManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.com.squareup.otto.Bus;

class ResetManager {
    private final Api.Provider apiProvider;
    private final UserIdentity userIdentity;
    private final OverlayManager overlayManager;
    private final AppIdentity appIdentity;
    private final Store<State> store;
    private final Bus bus;
    private final UserUpdateBatcher userUpdateBatcher;
    private final Context context;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Twig twig = LumberMill.getLogger();
    private final Runnable hardResetTask = new Runnable(){

        @Override
        public void run() {
            ResetManager.this.hardReset();
        }
    };

    ResetManager(Api.Provider apiProvider, UserIdentity userIdentity, OverlayManager overlayManager, AppIdentity appIdentity, Store<State> store, Bus bus, UserUpdateBatcher userUpdateBatcher, Context context) {
        this.apiProvider = apiProvider;
        this.userIdentity = userIdentity;
        this.overlayManager = overlayManager;
        this.appIdentity = appIdentity;
        this.store = store;
        this.bus = bus;
        this.userUpdateBatcher = userUpdateBatcher;
        this.context = context;
    }

    void softReset() {
        this.userUpdateBatcher.submitPendingUpdate();
        this.bus.post((Object)new CloseMessengerEvent());
        this.overlayManager.softReset();
        this.userIdentity.softReset();
        this.handler.postDelayed(this.hardResetTask, this.appIdentity.getAppConfig().getSoftResetTimeoutMs());
        this.store.dispatch(Actions.softReset());
        this.twig.i("Successfully reset the user. To resume communicating with Intercom, you can register a user", new Object[0]);
    }

    void hardReset() {
        this.handler.removeCallbacks(this.hardResetTask);
        if (this.userIdentity.isSoftReset()) {
            this.userIdentity.hardReset();
            this.appIdentity.getAppConfig().resetRealTimeConfig();
            String deviceToken = DeviceData.getDeviceToken(this.context);
            if (TextUtils.isEmpty((CharSequence)deviceToken)) {
                this.twig.internal("There is no device token to remove.");
            } else {
                this.apiProvider.getApi().removeDeviceToken(deviceToken);
            }
            this.store.dispatch(Actions.hardReset());
        }
    }

    public void clear() {
        this.handler.removeCallbacks(this.hardResetTask);
    }

    boolean shouldReset() {
        return this.userIdentity.isSoftReset();
    }
}

