/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class UserUpdateRequest {
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final boolean newSession;
    private final int batchSize;
    private final boolean sentFromBackground;

    public UserUpdateRequest() {
        this(false, true, null, 0);
    }

    public UserUpdateRequest(boolean newSession, boolean sentFromBackground) {
        this(newSession, sentFromBackground, null, 1);
    }

    public UserUpdateRequest(boolean newSession, boolean sentFromBackground, Map<String, Object> attributes) {
        this(newSession, sentFromBackground, attributes, 1);
    }

    @VisibleForTesting
    UserUpdateRequest(boolean newSession, boolean sentFromBackground, @Nullable Map<String, Object> attributes, int batchSize) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.sentFromBackground = sentFromBackground;
        this.newSession = newSession;
        this.batchSize = batchSize;
    }

    public boolean isValidUpdate() {
        return this.newSession || !this.attributes.isEmpty();
    }

    public boolean canMergeUpdate(UserUpdateRequest userUpdateRequest) {
        return !this.attributesWillOverwriteExistingAttributes(userUpdateRequest.attributes) && (!this.newSession || !userUpdateRequest.newSession);
    }

    public UserUpdateRequest merge(UserUpdateRequest userUpdateRequest) {
        boolean mergedNewSession = this.newSession || userUpdateRequest.newSession;
        Map<String, Object> mergedAttributes = UserUpdateRequest.mergeAttributes(this.attributes, userUpdateRequest.attributes);
        boolean mergedSentFromBackground = this.sentFromBackground && userUpdateRequest.sentFromBackground;
        int mergedBatchSize = this.batchSize + userUpdateRequest.batchSize;
        return new UserUpdateRequest(mergedNewSession, mergedSentFromBackground, mergedAttributes, mergedBatchSize);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isSentFromBackground() {
        return this.sentFromBackground;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdateRequest that = (UserUpdateRequest)o;
        if (this.newSession != that.newSession) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.sentFromBackground != that.sentFromBackground) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + (this.newSession ? 1 : 0);
        result = 31 * result + this.batchSize;
        result = 31 * result + (this.sentFromBackground ? 1 : 0);
        return result;
    }

    private boolean attributesWillOverwriteExistingAttributes(Map<String, Object> newAttributes) {
        Object newValue;
        Map<String, Object> existingCustomAttributes = UserUpdateRequest.getCustomAttributes(this.attributes);
        Map<String, Object> newCustomAttributes = UserUpdateRequest.getCustomAttributes(newAttributes);
        if (existingCustomAttributes != null && newCustomAttributes != null) {
            for (Map.Entry<String, Object> existingAttribute : existingCustomAttributes.entrySet()) {
                newValue = newCustomAttributes.get(existingAttribute.getKey());
                if (newValue == null || newValue.equals(existingAttribute.getValue())) continue;
                return true;
            }
        }
        for (Map.Entry<String, Object> existingAttribute : this.attributes.entrySet()) {
            if (CUSTOM_ATTRIBUTES.equals(existingAttribute.getKey()) || (newValue = newAttributes.get(existingAttribute.getKey())) == null || newValue.equals(existingAttribute.getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Map<String, Object> getCustomAttributes(Map<String, Object> map) {
        Object value = map.get(CUSTOM_ATTRIBUTES);
        return value instanceof Map ? (Map)value : null;
    }

    private static Map<String, Object> mergeAttributes(Map<String, Object> attributes, Map<String, Object> newAttributes) {
        HashMap<String, Object> mergedAttributes = new HashMap<String, Object>(attributes);
        HashMap<String, Object> existingCustomAttributes = UserUpdateRequest.getCustomAttributes(mergedAttributes);
        Map<String, Object> newCustomAttributes = UserUpdateRequest.getCustomAttributes(newAttributes);
        mergedAttributes.putAll(newAttributes);
        if (newCustomAttributes != null && !newCustomAttributes.isEmpty()) {
            HashMap<String, Object> customAttributes = existingCustomAttributes == null ? new HashMap<String, Object>() : existingCustomAttributes;
            customAttributes.putAll(newCustomAttributes);
            mergedAttributes.put(CUSTOM_ATTRIBUTES, customAttributes);
        } else if (existingCustomAttributes != null) {
            mergedAttributes.put(CUSTOM_ATTRIBUTES, existingCustomAttributes);
        } else {
            mergedAttributes.remove(CUSTOM_ATTRIBUTES);
        }
        return mergedAttributes;
    }
}

