/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import io.intercom.android.sdk.imageloader.LongTermImageDiskCache;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.request.animation.GlideAnimation;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class LongTermImageLoader
implements Closeable {
    private static final Twig twig = TwigFactory.getLogger();
    private static final int CACHE_SIZE = 0x1900000;
    private final LongTermImageDiskCache diskCache;
    private final Fetcher imageFetcher;

    public static LongTermImageLoader newInstance(Context context) {
        boolean directoryMade;
        File cacheDir = context.getCacheDir();
        File intercomCacheDirectory = new File(cacheDir, "intercom-glide");
        if (!intercomCacheDirectory.exists() && !(directoryMade = intercomCacheDirectory.mkdir())) {
            twig.e("Could not create directory: " + intercomCacheDirectory.getAbsolutePath(), new Object[0]);
        }
        LongTermImageDiskCache diskCache = new LongTermImageDiskCache(intercomCacheDirectory, 0x1900000);
        return new LongTermImageLoader(diskCache, new Fetcher(diskCache));
    }

    LongTermImageLoader(LongTermImageDiskCache diskCache, Fetcher imageFetcher) {
        this.diskCache = diskCache;
        this.imageFetcher = imageFetcher;
    }

    public void loadImage(String url, Context context, OnImageReadyListener onImageReadyListener) {
        OnImageReadyListener listener;
        File imageFile = this.diskCache.get(url);
        OnImageReadyListener onImageReadyListener2 = listener = onImageReadyListener == null ? OnImageReadyListener.NULL : onImageReadyListener;
        if (imageFile != null && imageFile.exists()) {
            this.imageFetcher.loadImageFromFile(url, context, imageFile, listener);
        } else {
            this.imageFetcher.fetchImageFromWeb(url, context, listener);
        }
    }

    @Override
    public void close() throws IOException {
        this.diskCache.close();
    }

    static class Fetcher {
        final LongTermImageDiskCache diskCache;

        Fetcher(LongTermImageDiskCache diskCache) {
            this.diskCache = diskCache;
        }

        void loadImageFromFile(final String url, final Context context, File imageFile, final OnImageReadyListener onImageReadyListener) {
            Glide.with((Context)context).load(imageFile).asBitmap().diskCacheStrategy(DiskCacheStrategy.NONE).into((Target)new SimpleTarget<Bitmap>(Integer.MIN_VALUE, Integer.MIN_VALUE){

                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                    Fetcher.this.fetchImageFromWeb(url, context, onImageReadyListener);
                }

                public void onResourceReady(Bitmap bitmap, GlideAnimation anim) {
                    onImageReadyListener.onImageReady(bitmap);
                }
            });
        }

        void fetchImageFromWeb(final String url, Context context, final OnImageReadyListener onImageReadyListener) {
            Glide.with((Context)context).load(url).asBitmap().diskCacheStrategy(DiskCacheStrategy.NONE).into((Target)new SimpleTarget<Bitmap>(Integer.MIN_VALUE, Integer.MIN_VALUE){

                public void onResourceReady(Bitmap bitmap, GlideAnimation<? super Bitmap> glideAnimation) {
                    onImageReadyListener.onImageReady(bitmap);
                    if (!Fetcher.this.diskCache.isClosed()) {
                        Fetcher.this.diskCache.put(url, bitmap);
                    }
                }
            });
        }
    }

    public static interface OnImageReadyListener {
        public static final OnImageReadyListener NULL = new OnImageReadyListener(){

            @Override
            public void onImageReady(Bitmap bitmap) {
            }
        };

        public void onImageReady(Bitmap var1);
    }
}

