/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Px;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import java.util.List;

public class AuthorAvatarView
extends FrameLayout {
    private final ImageView leftImageView;
    private final ImageView rightImageView;
    private final ImageView topImageView;
    @Px
    private final int imageViewSize;
    @Px
    private final int teamAvatarPadding;

    public AuthorAvatarView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorAvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.leftImageView = new ImageView(context);
        this.rightImageView = new ImageView(context);
        this.topImageView = new ImageView(context);
        this.addView((View)this.rightImageView);
        this.addView((View)this.topImageView);
        this.addView((View)this.leftImageView);
        this.leftImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.rightImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.topImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.teamAvatarPadding = ScreenUtils.dpToPx((float)1.0f, (Context)context);
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.topImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AuthorAvatarView, 0, 0);
        try {
            this.imageViewSize = a.getDimensionPixelSize(R.styleable.AuthorAvatarView_avatarSize, 0);
        }
        finally {
            a.recycle();
        }
    }

    public void loadAvatars(List<Participant> participants) {
        switch (participants.size()) {
            case 0: {
                this.loadDefaultDrawable();
                break;
            }
            case 1: {
                this.loadSingleAvatar(participants.get(0));
                break;
            }
            case 2: {
                this.loadTwoAvatars(participants.get(0), participants.get(1));
                break;
            }
            default: {
                this.loadThreeAvatars(participants.get(0), participants.get(1), participants.get(2));
            }
        }
    }

    private void loadDefaultDrawable() {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.leftImageView.setPadding(0, 0, 0, 0);
        this.setNumberOfVisibleViews(1);
        this.requestLayout();
        this.leftImageView.setImageDrawable((Drawable)AvatarUtils.getDefaultDrawable(this.leftImageView.getContext()));
    }

    private void loadSingleAvatar(Participant participant) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.leftImageView.setPadding(0, 0, 0, 0);
        this.setNumberOfVisibleViews(1);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(participant.getAvatar(), this.leftImageView);
    }

    private void loadTwoAvatars(Participant leftParticipant, Participant rightParticipant) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 19));
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 21));
        this.setNumberOfVisibleViews(2);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(leftParticipant.getAvatar(), this.leftImageView);
        AvatarUtils.loadAvatarIntoView(rightParticipant.getAvatar(), this.rightImageView);
    }

    private void loadThreeAvatars(Participant leftParticipant, Participant rightParticipant, Participant topParticipant) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 83));
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 85));
        this.topImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 49));
        this.setNumberOfVisibleViews(3);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(leftParticipant.getAvatar(), this.leftImageView);
        AvatarUtils.loadAvatarIntoView(rightParticipant.getAvatar(), this.rightImageView);
        AvatarUtils.loadAvatarIntoView(topParticipant.getAvatar(), this.topImageView);
    }

    private void setNumberOfVisibleViews(int visibleCount) {
        this.leftImageView.setVisibility(visibleCount >= 1 ? 0 : 8);
        this.rightImageView.setVisibility(visibleCount >= 2 ? 0 : 8);
        this.topImageView.setVisibility(visibleCount >= 3 ? 0 : 8);
    }
}

