/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.store.Store;

public class ChangeSubscriber<S, T>
implements Store.Subscriber<S> {
    private final Store.Selector<S, T> selector;
    final Store.Subscriber<T> subscriber;
    private final Handler mainHandler;
    private T last = null;

    public ChangeSubscriber(Store.Selector<S, T> selector, Store.Subscriber<T> subscriber) {
        this(selector, subscriber, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    ChangeSubscriber(Store.Selector<S, T> selector, Store.Subscriber<T> subscriber, Handler mainHandler) {
        this.selector = selector;
        this.subscriber = subscriber;
        this.mainHandler = mainHandler;
    }

    @Override
    public void onStateChange(S state) {
        final T current = this.selector.transform(state);
        if (this.last != current) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.subscriber.onStateChange(current);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChangeSubscriber.this.subscriber.onStateChange(current);
                    }
                });
            }
            this.last = current;
        }
    }
}

