/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.Map;

class PushPayload {
    private static final String PUSH_ONLY = "push_only";
    private final String conversationId;
    private final String message;
    private final String body;
    private final String authorName;
    private final String imageUrl;
    private final String appName;
    private final String receiver;
    private final String intercomPushType;
    private final String uri;
    private final String pushOnlyConversationId;
    private final String title;
    private final int priority;

    PushPayload(Bundle extras) {
        this.conversationId = extras.getString("conversation_id", "");
        this.message = extras.getString("message", "");
        this.body = extras.getString("body", "");
        this.authorName = extras.getString("author_name", "");
        this.imageUrl = extras.getString("image_url", "");
        this.appName = extras.getString("app_name", "");
        this.receiver = extras.getString("receiver", "");
        this.intercomPushType = extras.getString("intercom_push_type", "");
        this.uri = extras.getString("uri", "");
        this.pushOnlyConversationId = extras.getString("push_only_conv_id", "");
        this.title = extras.getString("title", "");
        this.priority = extras.getInt("intercom_priority_type", 1);
    }

    PushPayload(Map<String, String> remoteMessage) {
        this.conversationId = this.getValueWithDefault(remoteMessage, "conversation_id", "");
        this.message = this.getValueWithDefault(remoteMessage, "message", "");
        this.body = this.getValueWithDefault(remoteMessage, "body", "");
        this.authorName = this.getValueWithDefault(remoteMessage, "author_name", "");
        this.imageUrl = this.getValueWithDefault(remoteMessage, "image_url", "");
        this.appName = this.getValueWithDefault(remoteMessage, "app_name", "");
        this.receiver = this.getValueWithDefault(remoteMessage, "receiver", "");
        this.intercomPushType = this.getValueWithDefault(remoteMessage, "intercom_push_type", "");
        this.uri = this.getValueWithDefault(remoteMessage, "uri", "");
        this.pushOnlyConversationId = this.getValueWithDefault(remoteMessage, "push_only_conv_id", "");
        this.title = this.getValueWithDefault(remoteMessage, "title", "");
        String priorityValue = this.getValueWithDefault(remoteMessage, "intercom_priority_type", "1");
        this.priority = Integer.valueOf(priorityValue);
    }

    private String getValueWithDefault(Map<String, String> remoteMessage, String key, String defaultValue) {
        if (remoteMessage.containsKey(key)) {
            return remoteMessage.get(key);
        }
        return defaultValue;
    }

    String getConversationId() {
        return this.conversationId;
    }

    String getMessage() {
        return !this.message.isEmpty() ? this.message : this.body;
    }

    String getName() {
        return this.authorName;
    }

    @SuppressLint(value={"PrivateResource"})
    CharSequence getTitle(Context context) {
        if (!this.title.isEmpty()) {
            return this.title;
        }
        if (!this.authorName.isEmpty() && !this.appName.isEmpty()) {
            return Phrase.from(context, R.string.intercom_teammate_from_company).put("name", this.authorName).put("company", this.appName).format();
        }
        if (!this.authorName.isEmpty()) {
            return this.authorName;
        }
        return this.appName;
    }

    String getImageUrl() {
        return this.imageUrl;
    }

    String getUri() {
        return this.uri;
    }

    String getPushOnlyConversationId() {
        return this.pushOnlyConversationId;
    }

    boolean isIntercomPush() {
        return !this.intercomPushType.isEmpty() && "intercom_sdk".equals(this.receiver);
    }

    boolean isPushOnly() {
        return PUSH_ONLY.equals(this.intercomPushType);
    }

    int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushPayload that = (PushPayload)o;
        if (this.priority != that.priority) {
            return false;
        }
        if (this.conversationId != null ? !this.conversationId.equals(that.conversationId) : that.conversationId != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.authorName != null ? !this.authorName.equals(that.authorName) : that.authorName != null) {
            return false;
        }
        if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
            return false;
        }
        if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
            return false;
        }
        if (this.receiver != null ? !this.receiver.equals(that.receiver) : that.receiver != null) {
            return false;
        }
        if (this.intercomPushType != null ? !this.intercomPushType.equals(that.intercomPushType) : that.intercomPushType != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.pushOnlyConversationId != null ? !this.pushOnlyConversationId.equals(that.pushOnlyConversationId) : that.pushOnlyConversationId != null) {
            return false;
        }
        return this.title != null ? this.title.equals(that.title) : that.title == null;
    }

    public int hashCode() {
        int result = this.conversationId != null ? this.conversationId.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
        result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
        result = 31 * result + (this.appName != null ? this.appName.hashCode() : 0);
        result = 31 * result + (this.receiver != null ? this.receiver.hashCode() : 0);
        result = 31 * result + (this.intercomPushType != null ? this.intercomPushType.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.pushOnlyConversationId != null ? this.pushOnlyConversationId.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + this.priority;
        return result;
    }
}

