/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import java.io.IOException;

public class WallpaperLoader {
    private static final float DEFAULT_WALLPAPER_DENSITY = 1.0f;
    private final LongTermImageLoader imageLoader;
    private final AppConfig.Provider appConfigProvider;

    public static WallpaperLoader create(Context context, AppConfig.Provider appConfigProvider) {
        return new WallpaperLoader(LongTermImageLoader.newInstance(context), appConfigProvider);
    }

    WallpaperLoader(LongTermImageLoader imageLoader, AppConfig.Provider appConfigProvider) {
        this.imageLoader = imageLoader;
        this.appConfigProvider = appConfigProvider;
    }

    public void loadWallpaperInto(final ImageView imageView, final Listener listener) {
        String wallpaperUrl = this.appConfigProvider.getAppConfig().getWallpaper();
        if (TextUtils.isEmpty((CharSequence)wallpaperUrl)) {
            return;
        }
        this.imageLoader.loadImage(wallpaperUrl, imageView.getContext(), new LongTermImageLoader.OnImageReadyListener(){

            @Override
            public void onImageReady(Bitmap bitmap) {
                Context context = imageView.getContext();
                if (context == null) {
                    return;
                }
                Bitmap renderedWallpaper = WallpaperLoader.this.renderWallpaper(bitmap, context);
                BitmapDrawable tiledWallpaper = new BitmapDrawable(context.getResources(), renderedWallpaper);
                tiledWallpaper.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                imageView.setImageDrawable((Drawable)tiledWallpaper);
                listener.onLoadComplete();
            }
        });
    }

    Bitmap renderWallpaper(Bitmap bitmap, Context context) {
        float targetDensity = context.getResources().getDisplayMetrics().density / 1.0f;
        int tileWidthPx = (int)((float)bitmap.getWidth() * targetDensity);
        int tileHeightPx = (int)((float)bitmap.getHeight() * targetDensity);
        Bitmap finalBitmap = Bitmap.createBitmap((int)tileWidthPx, (int)tileHeightPx, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(finalBitmap);
        WallpaperLoader.fillWithWhite(canvas);
        Rect inputRect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        Rect outputRect = new Rect(0, 0, tileWidthPx, tileHeightPx);
        canvas.drawBitmap(bitmap, inputRect, outputRect, null);
        return finalBitmap;
    }

    private static void fillWithWhite(Canvas canvas) {
        canvas.drawARGB(255, 255, 255, 255);
    }

    public void close() throws IOException {
        this.imageLoader.close();
    }

    public static interface Listener {
        public void onLoadComplete();
    }
}

