/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import io.intercom.android.sdk.nexus.NexusEvent;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public enum NexusEventType {
    NewComment{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    NewMessage{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    CreateConversation{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    ConversationSeen{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.FromUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    UserIsTyping{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.FromUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    AdminIsTyping{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminName", (Object)nexusEvent.getAdminName());
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            eventData.put("adminAvatar", (Object)nexusEvent.getAdminAvatarUrl());
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    AdminIsTypingANote{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminName", (Object)nexusEvent.getAdminName());
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            eventData.put("adminAvatar", (Object)nexusEvent.getAdminAvatarUrl());
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    NewNote{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            return event;
        }
    }
    ,
    ConversationAssigned{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            eventData.put("assigneeId", (Object)nexusEvent.getAssigneeId());
            return event;
        }
    }
    ,
    ConversationClosed{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.optJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            return event;
        }
    }
    ,
    ConversationReopened{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            JSONObject eventData = event.getJSONObject("eventData");
            eventData.put("adminId", (Object)nexusEvent.getAdminId());
            return event;
        }
    }
    ,
    UserPresence{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = new JSONObject();
            JSONObject eventData = new JSONObject();
            event.put("eventGuid", (Object)UUID.randomUUID().toString());
            event.put("eventName", (Object)("nx." + this.name()));
            event.put("eventData", (Object)eventData);
            return event;
        }
    }
    ,
    UserContentSeenByAdmin{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("nx.ToUser", (Object)nexusEvent.getUserId());
            return event;
        }
    }
    ,
    Subscribe{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("eventName", (Object)("nx." + this.name()));
            return event;
        }
    }
    ,
    Unsubscribe{

        @Override
        protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
            JSONObject event = super.toJsonObject(nexusEvent);
            event.put("eventName", (Object)("nx." + this.name()));
            return event;
        }
    }
    ,
    UNKNOWN{

        @Override
        protected String toStringEncodedJsonObject(NexusEvent nexusEvent) {
            return "";
        }
    };


    protected String toStringEncodedJsonObject(NexusEvent nexusEvent) {
        try {
            return this.toJsonObject(nexusEvent).toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    protected JSONObject toJsonObject(NexusEvent nexusEvent) throws JSONException {
        JSONObject event = new JSONObject();
        JSONObject eventData = new JSONObject();
        eventData.put("conversationId", (Object)nexusEvent.getConversationId());
        event.put("eventGuid", (Object)nexusEvent.getGuid());
        event.put("eventName", (Object)this.name());
        event.put("eventData", (Object)eventData);
        List<String> topics = nexusEvent.getTopics();
        if (!topics.isEmpty()) {
            event.put("nx.Topics", (Object)new JSONArray(topics));
        }
        return event;
    }

    public static NexusEventType safeValueOf(String name) {
        try {
            return NexusEventType.valueOf(name);
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }
}

