/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.Spanned;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.NotificationChannelsCardBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.sdk.blocks.models.NotificationChannelsCard;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.HtmlCompat;

class Paragraph
implements ParagraphBlock,
NotificationChannelsCardBlock {
    private final StyleType style;
    private final Context context;
    private final AppConfig.Provider appConfigProvider;

    Paragraph(Context context, StyleType style, AppConfig.Provider appConfigProvider) {
        this.context = context;
        this.style = style;
        this.appConfigProvider = appConfigProvider;
    }

    public View addParagraph(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        int baseColor = this.appConfigProvider.getAppConfig().getBaseColor();
        ParagraphView textview = new ParagraphView(this.context, this.style, alignment, baseColor);
        if (StyleType.PREVIEW == this.style) {
            textview.setText(text.toString());
        } else {
            textview.setText((CharSequence)text);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        return textview;
    }

    public View addNotificationChannelsCardBlock(NotificationChannelsCard card, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Spanned text = HtmlCompat.fromHtml(card.getText());
        return this.addParagraph(text, BlockAlignment.CENTER, isFirstObject, isLastObject, parent);
    }
}

