/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.NonNull;
import io.intercom.android.sdk.IntercomLifecycleTracker;
import io.intercom.android.sdk.MainThreadBus;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.android.sdk.push.IntercomNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.StoreFactory;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;

public class Injector
implements Api.Provider {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Injector instance;
    private final Application application;
    private final AppIdentity appIdentity;
    private MainThreadBus bus;
    private NexusWrapper nexusClient;
    private UserIdentity userIdentity;
    private DeDuper superDeDuper;
    private Api api;
    private MetricsStore metricsStore;
    private PreviewManager previewManager;
    private IntercomLifecycleTracker lifecycleTracker;
    private IntercomNotificationManager intercomNotificationManager;
    private Store<State> store;

    public static synchronized void init(Application application) {
        if (instance == null) {
            AppIdentity appIdentity = new AppIdentity((Context)application);
            Injector.initWithAppCredentials(application, appIdentity.getApiKey(), appIdentity.getAppId());
        }
    }

    public static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance == null) {
            IntercomLogger.internal("Injector", "Initializing");
            AppIdentity appIdentity = new AppIdentity((Context)application);
            appIdentity.update(apiKey, appId);
            instance = new Injector(application, appIdentity);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
        }
    }

    protected Injector(Application application, AppIdentity appIdentity) {
        this.application = application;
        this.appIdentity = appIdentity;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    public Application getApplication() {
        return this.application;
    }

    @NonNull
    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    @NonNull
    public UserIdentity getUserIdentity() {
        if (this.userIdentity == null) {
            this.userIdentity = new UserIdentity((Context)this.getApplication());
        }
        return this.userIdentity;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public NexusClient getNexusClient() {
        if (this.nexusClient == null) {
            this.nexusClient = new NexusWrapper(this.getBus());
            this.nexusClient.setLoggingEnabled(false);
        }
        return this.nexusClient;
    }

    public DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            this.superDeDuper = new DeDuper(this.getAppIdentity());
        }
        return this.superDeDuper;
    }

    @Override
    public Api getApi() {
        if (this.api == null) {
            String hostname = ApiFactory.getHostname((Context)this.getApplication(), this.getAppIdentity());
            this.api = ApiFactory.create((Context)this.getApplication(), this.getAppIdentity(), this.getUserIdentity(), this.getBus(), this.getNexusClient(), this.getStore(), hostname);
        }
        this.api.updateMaxRequests();
        return this.api;
    }

    public MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this, this.getAppIdentity());
            this.metricsStore.loadCachedMetrics();
        }
        return this.metricsStore;
    }

    public PreviewManager getPreviewManager() {
        if (this.previewManager == null) {
            this.previewManager = new PreviewManager(this.getApplication(), this.getBus(), this.getStore(), this.getAppIdentity(), new SoundPlayer((Context)this.getApplication()), this.getMetricsStore(), new MetricFactory(this.getUserIdentity()));
        }
        return this.previewManager;
    }

    public Store<State> getStore() {
        if (this.store == null) {
            this.store = StoreFactory.createStore();
        }
        return this.store;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public IntercomNotificationManager getIntercomNotificationManager() {
        if (this.intercomNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)this.application.getSystemService("notification");
            this.intercomNotificationManager = new IntercomNotificationManager(notificationManager);
        }
        return this.intercomNotificationManager;
    }

    public IntercomLifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = new IntercomLifecycleTracker(this, this.getDeDuper(), this.getMetricsStore(), this.getNexusClient(), this.getAppIdentity(), this.getTimeProvider(), this.getIntercomNotificationManager());
        }
        return this.lifecycleTracker;
    }
}

