/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomPostActivity
extends IntercomBaseActivity
implements IntercomToolbar.Listener,
View.OnClickListener {
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String POST_PREVIEW = "is_post_preview";
    private static final String LAST_PARTICIPANT = "last_participant";
    private Part part;
    private IntercomToolbar intercomToolbar;
    private FrameLayout postContainer;
    private ContentAwareScrollView postView;
    private String conversationId;
    private View composerLayout;
    private ComposerInputView textComposer;
    private ReactionInputView reactionComposer;
    private LastParticipatingAdmin lastParticipatingAdmin;
    private boolean isPreview = false;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_post);
        Injector injector = Injector.get();
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        this.metricFactory = new MetricFactory(userIdentity);
        this.metricStore = Injector.get().getMetricsStore();
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.part = new Part();
        this.lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                String teamMateName = "";
                if (this.part != null && this.part.getParticipant() != null) {
                    teamMateName = this.part.getParticipant().getForename();
                }
                String appName = injector.getAppIdentity().getAppConfig().getName();
                CharSequence title = Phrase.from((Context)this, R.string.intercom_teammate_from_company).put("name", teamMateName).put("company", appName).format();
                this.intercomToolbar.setTitle(title);
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
                injector.getStore().dispatch(Actions.conversationMarkedAsRead(this.conversationId));
                injector.getApi().markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(POST_PREVIEW)) {
                this.isPreview = data.getBoolean(POST_PREVIEW, false);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
                if (!LastParticipatingAdmin.isNull(this.lastParticipatingAdmin)) {
                    TimeFormatter timeFormatter = new TimeFormatter((Context)this, injector.getTimeProvider());
                    long lastActiveTime = this.lastParticipatingAdmin.getLastActiveAt();
                    this.intercomToolbar.setSubtitle(timeFormatter.getAdminActiveStatus(lastActiveTime));
                }
            }
        }
        this.intercomToolbar.setVisibility(8);
        this.intercomToolbar.setUpPostToolbar(this.part.getParticipant().getAvatar());
        int primaryColor = injector.getAppIdentity().getAppConfig().getBaseColor();
        View background = this.getWindow().getDecorView();
        background.setBackgroundColor(Color.argb((int)153, (int)Color.red((int)primaryColor), (int)Color.green((int)primaryColor), (int)Color.blue((int)primaryColor)));
        ViewHolderGenerator viewHolderGenerator = new ViewHolderGenerator((Context)this, new UploadingImageCache(), injector, injector.getAppIdentity());
        BlocksViewHolder postHolder = viewHolderGenerator.getPostHolder();
        this.postContainer = (FrameLayout)this.findViewById(R.id.post_container);
        this.composerLayout = this.findViewById(R.id.conversation_coordinator);
        this.textComposer = (ComposerInputView)this.findViewById(R.id.composer_input_view);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        this.postView = (ContentAwareScrollView)this.findViewById(R.id.post_view);
        LinearLayout partsView = ViewHolderGenerator.createPartsLayout(postHolder, this.part, (Context)this);
        this.postView.addView(BlockUtils.getBlockView((ViewGroup)this.postView, partsView, (Context)this));
        if (this.isPreview && !ReactionReply.isNull(this.part.getReactionReply())) {
            this.postView.setListener(new ContentAwareScrollView.Listener(){

                @Override
                public void onBottomReached() {
                    IntercomPostActivity.this.postView.setListener(null);
                    if (IntercomPostActivity.this.composerLayout.getVisibility() != 0) {
                        IntercomPostActivity.this.composerLayout.setVisibility(0);
                        IntercomPostActivity.this.reactionComposer.setUpReactions(IntercomPostActivity.this.part.getReactionReply(), IntercomPostActivity.this.conversationId, IntercomPostActivity.this.part.getId(), ReactionInputView.ReactionLocation.IN_APP, true, IntercomPostActivity.this.metricStore, IntercomPostActivity.this.metricFactory);
                    }
                }
            });
            this.reactionComposer.preloadReactionImages(this.part.getReactionReply());
        }
        if (this.openedFromConversation()) {
            this.metricStore.track(this.metricFactory.viewedInAppFromMessenger(this.conversationId, this.part.getId()));
        }
        background.setAlpha(0.0f);
        background.animate().alpha(1.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.animateToolbar();
                IntercomPostActivity.this.animateContent();
                if (IntercomPostActivity.this.openedFromConversation()) {
                    IntercomPostActivity.this.composerLayout.setVisibility(8);
                } else if (ReactionReply.isNull(IntercomPostActivity.this.part.getReactionReply())) {
                    View touchTarget = IntercomPostActivity.this.findViewById(R.id.post_touch_target);
                    touchTarget.setOnClickListener((View.OnClickListener)IntercomPostActivity.this);
                    IntercomPostActivity.this.animateComposer();
                }
            }
        }).start();
    }

    private void animateToolbar() {
        this.intercomToolbar.setY(this.intercomToolbar.getY() + (float)ScreenUtils.dpToPx((float)200.0f, (Context)this));
        this.intercomToolbar.setVisibility(0);
        this.intercomToolbar.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    private void animateContent() {
        this.postContainer.setY(this.postContainer.getY() + (float)ScreenUtils.dpToPx((float)400.0f, (Context)this));
        this.postContainer.setVisibility(0);
        this.postContainer.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    private void animateComposer() {
        this.composerLayout.setY(this.composerLayout.getY() + (float)ScreenUtils.dpToPx((float)156.0f, (Context)this));
        this.composerLayout.setVisibility(0);
        this.textComposer.setVisibility(0);
        this.composerLayout.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    private void closePost() {
        View background = this.getWindow().getDecorView();
        background.setAlpha(1.0f);
        background.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.finish();
                IntercomPostActivity.this.overridePendingTransition(0, 0);
            }
        }).start();
    }

    public static Intent buildPostIntent(@NonNull Context context, @NonNull Part part, @NonNull String conversationId, @NonNull LastParticipatingAdmin lastParticipatingAdmin, boolean isPreview) {
        Intent intent = new Intent(context, IntercomPostActivity.class);
        intent.putExtra(PARCEL_PART, (Parcelable)part);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        intent.putExtra(POST_PREVIEW, isPreview);
        intent.setFlags(0x10000000);
        return intent;
    }

    private boolean openedFromConversation() {
        return !this.isPreview;
    }

    public void onBackPressed() {
        this.closePost();
        if (this.isPreview) {
            this.metricStore.track(this.metricFactory.closedInAppFromFull(this.conversationId, this.part.getId()));
        }
    }

    @Override
    public void onCloseClicked() {
        this.onBackPressed();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.post_touch_target) {
            this.closePost();
            if (this.isPreview) {
                this.metricStore.track(this.metricFactory.openedConversationFromFull(this.conversationId, this.part.getId()));
                this.startActivity(IntercomMessengerActivity.openConversation((Context)this, this.conversationId, this.lastParticipatingAdmin));
            }
        }
    }
}

