/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import io.intercom.android.sdk.logger.IntercomLogger;

public class Gcm {
    private static final String PREFS_SENDER_ID = "intercom_sender_id";
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String ACTION_REMOVE_NOTIFICATION = "intercom_sdk_remove_notification";
    public static final String PUSH_ONLY_ID = "push_only_convo_id";
    public static final String INTERCOM_PUSH_KEY = "intercom_push_key";

    public static boolean shouldStartGcmService() {
        return Gcm.getGcmRegistrationServiceClass() != null;
    }

    public static void startGcmRegistrationService(Context context) {
        Class intercomGcmRegistrationClass = Gcm.getGcmRegistrationServiceClass();
        Intent intent = new Intent(context, intercomGcmRegistrationClass);
        context.startService(intent);
    }

    public static void clearNotifications(Context context) {
        Class intentClass = Gcm.getGcmIntentClass();
        if (intentClass != null) {
            Intent intent = new Intent(context, intentClass);
            intent.setAction(ACTION_REMOVE_NOTIFICATION);
            context.startService(intent);
        }
    }

    public static void changeComponentState(int newState, Context context) {
        Class broadcastReceiverClass = Gcm.getGcmBroadcastReceiverClass();
        Class intentClass = Gcm.getGcmIntentClass();
        if (broadcastReceiverClass != null && intentClass != null) {
            ComponentName gcmReceiverComponent = new ComponentName(context, broadcastReceiverClass);
            ComponentName gcmServiceComponent = new ComponentName(context, intentClass);
            PackageManager packageManager = context.getPackageManager();
            packageManager.setComponentEnabledSetting(gcmReceiverComponent, newState, 1);
            packageManager.setComponentEnabledSetting(gcmServiceComponent, newState, 1);
            IntercomLogger.internal("component state", "broadcast receiver is enabled: " + Gcm.isComponentEnabled(gcmReceiverComponent, packageManager));
            IntercomLogger.internal("component state", "gcm service is enabled: " + Gcm.isComponentEnabled(gcmServiceComponent, packageManager));
        }
    }

    private static boolean isComponentEnabled(ComponentName componentName, PackageManager packageManager) {
        return packageManager.getComponentEnabledSetting(componentName) == 1;
    }

    public static boolean gcmModuleInstalled() {
        return Gcm.getGcmIntentClass() != null && Gcm.getGcmBroadcastReceiverClass() != null;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static void cacheSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        prefs.edit().putString(PREFS_SENDER_ID, senderId).commit();
    }

    public static String getSenderId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        return prefs.getString(PREFS_SENDER_ID, "");
    }

    private static Class getGcmIntentClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmIntentService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getGcmBroadcastReceiverClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmBroadcastReceiver");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getGcmRegistrationServiceClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmRegistrationService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

