/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.attachments.AttachmentActivity;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimestampAdder;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.RecyclerConversationAdapter;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.conversation.events.SendingEvent;
import io.intercom.android.sdk.fragments.IntercomSupportFragment;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.profile.ProfileCoordinator;
import io.intercom.android.sdk.store.LastViewStore;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.NetworkConnectivityListener;
import io.intercom.android.sdk.utilities.NetworkState;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.TimeProvider;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ConversationFragment
extends IntercomSupportFragment
implements RecyclerConversationAdapter.PartClickedListener {
    private static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final String ARG_LAST_PARTICIPANT = "last_participant";
    private static final int ACTIVITY_RESULT_UPLOAD_SELECTED = 1;
    private static final int ACTIVITY_RESULT_UPLOAD_CONFIRMED = 2;
    private static final int REQUEST_READ_EXTERNAL_STORAGE = 1;
    private static final long TIMESTAMP_UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private static final long PART_DISPLAY_DELIVERED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private final NetworkConnectivityListener networkConnectivityListener = new NetworkConnectivityListener();
    private final Set<String> currentTypers = new HashSet<String>();
    private final List<Part> sendingFailures = new ArrayList<Part>();
    private final TimestampAdder timestampAdder = TimestampAdder.create();
    private final UploadingImageCache uploadingImageCache = new UploadingImageCache();
    private Listener listener;
    private String conversationId;
    private ViewHolderGenerator generator;
    private RecyclerConversationAdapter adapter;
    private Blocks blocks;
    private List<Part> conversationParts;
    private BlocksViewHolder blocksUserViewHolder;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private BlocksViewHolder blocksAdminViewHolder;
    private View rootView;
    private ComposerInputView textComposer;
    private ReactionInputView reactionComposer;
    private RecyclerView conversationList;
    private IntercomErrorView intercomErrorView;
    private TextView pill;
    private ProfileCoordinator profileCoordinator;
    private LinearLayoutManager layoutManager;
    private WallpaperLoader wallpaperLoader;
    private Conversation conversation;
    private LastParticipatingAdmin lastParticipant;
    private SoundPlayer soundPlayer;
    private NetworkState networkState;
    private CharSequence lastActiveTime;
    private boolean canOpenProfile = true;
    private boolean profileWillOpen = false;
    @Nullable
    private Part markedPart = null;
    @Nullable
    private Part loadingPart = null;
    private Bus bus;
    private Api api;
    private NexusClient nexusClient;
    private TeamPresenceProvider teamPresenceProvider;
    private AppIdentity appIdentity;
    private UserIdentity userIdentity;
    private LastViewStore lastViewStore;
    private FrameLayout composerHolder;
    private boolean hasLoadedConversation = false;
    private boolean orientationChanged = false;
    private int currentOrientation;
    private IntercomLinkView intercomLinkView;
    private boolean shouldShowIntercomLink = false;
    private boolean wasAtBottom = false;
    private ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener;
    private final Handler connectivityMonitor = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (ConversationFragment.this.networkState != ConversationFragment.this.networkConnectivityListener.getState()) {
                if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_no_network_connection, (int)-2).show();
                } else if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.CONNECTED && ConversationFragment.this.networkState == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_connected, (int)0).setActionTextColor(ConversationFragment.this.appIdentity.getAppConfig().getBaseColor()).setAction(R.string.intercom_dismiss, new View.OnClickListener(){

                        public void onClick(View v) {
                        }
                    }).show();
                }
                ConversationFragment.this.networkState = ConversationFragment.this.networkConnectivityListener.getState();
            }
            return false;
        }
    });
    private final Runnable timestampUpdater = new Runnable(){

        @Override
        public void run() {
            ConversationFragment.this.adapter.notifyDataSetChanged();
            ConversationFragment.this.postOnView(ConversationFragment.this.timestampUpdater, TIMESTAMP_UPDATE_PERIOD);
        }
    };

    public static ConversationFragment newInstance(String conversationId, LastParticipatingAdmin participant, boolean isRead) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putParcelable(ARG_LAST_PARTICIPANT, (Parcelable)participant);
        args.putBoolean(ARG_IS_READ, isRead);
        frag.setArguments(args);
        return frag;
    }

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.init(this.getActivity().getApplication());
        Injector injector = Injector.get();
        this.bus = injector.getBus();
        this.api = injector.getApi();
        this.nexusClient = injector.getNexusClient();
        this.appIdentity = injector.getAppIdentity();
        this.userIdentity = injector.getUserIdentity();
        this.teamPresenceProvider = injector.getTeamPresenceProvider();
        this.lastViewStore = injector.getLastViewStore();
        this.conversationParts = new ArrayList<Part>();
        this.generator = new ViewHolderGenerator((Context)this.getActivity(), this.uploadingImageCache);
        this.blocksUserViewHolder = this.generator.getUserHolder();
        this.blocksAnnouncementViewHolder = this.generator.getContainerCardHolder();
        this.blocksAdminViewHolder = this.generator.getAdminHolder();
        Bundle args = this.getArguments();
        if (args != null) {
            boolean isRead;
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.lastParticipant = (LastParticipatingAdmin)args.getParcelable(ARG_LAST_PARTICIPANT);
            if (this.lastParticipant == null) {
                this.lastParticipant = LastParticipatingAdmin.NULL;
            }
            if (!(isRead = args.getBoolean(ARG_IS_READ, false))) {
                injector.getUnreadCountTracker().removeId(this.conversationId);
            }
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.lastViewStore.setLastState(LastViewStore.State.COMPOSER);
            } else {
                this.lastViewStore.setLastState(LastViewStore.State.CONVERSATION);
                this.lastViewStore.setLastViewedConversationId(this.conversationId);
            }
        }
        this.conversationParts = new ArrayList<Part>();
        this.conversation = new Conversation();
        this.soundPlayer = new SoundPlayer((Context)this.getActivity());
        this.networkState = NetworkState.UNKNOWN;
        this.currentOrientation = this.getResources().getConfiguration().orientation;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.pill = (TextView)this.rootView.findViewById(R.id.pill);
        this.pill.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.pill.setVisibility(8);
                ConversationFragment.this.conversationList.smoothScrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
            }
        });
        this.composerHolder = (FrameLayout)this.rootView.findViewById(R.id.composer_holder);
        this.profileCoordinator = new ProfileCoordinator((CoordinatorLayout)this.rootView.findViewById(R.id.conversation_coordinator_layout));
        this.profileCoordinator.setConversationId(this.conversationId);
        this.conversationList = (RecyclerView)this.rootView.findViewById(R.id.conversation_list);
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout);
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.displayLoadingView();
                ConversationFragment.this.api.getConversation(ConversationFragment.this.conversationId);
            }
        });
        this.blocks = new Blocks((Context)this.getActivity());
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration((Context)this.getActivity(), this.conversationParts));
        this.adapter = RecyclerConversationAdapter.create((Context)this.getActivity(), this.conversationParts, this);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.bus.register((Object)this);
        this.intercomLinkView = (IntercomLinkView)this.rootView.findViewById(R.id.intercom_link);
        this.intercomLinkView.setAlpha(0.0f);
        this.shouldShowIntercomLink = Injector.get().getAppIdentity().getAppConfig().shouldShowIntercomLink();
        if (this.shouldShowIntercomLink) {
            int bottomPadding = this.conversationList.getPaddingBottom() + this.getResources().getDimensionPixelSize(R.dimen.intercom_link_height);
            this.conversationList.setPadding(this.conversationList.getPaddingLeft(), this.conversationList.getPaddingTop(), this.conversationList.getPaddingRight(), bottomPadding);
            this.intercomLinkView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    boolean interceptEvent;
                    int action = MotionEventCompat.getActionMasked((MotionEvent)event);
                    boolean bl = interceptEvent = ConversationFragment.this.intercomLinkView.getAlpha() == 1.0f;
                    if (interceptEvent && 1 == action) {
                        ConversationFragment.this.intercomLinkView.followIntercomLink(ConversationFragment.this.appIdentity, ConversationFragment.this.getFirstMessagePart());
                    }
                    return interceptEvent;
                }
            });
            this.profileCoordinator.addListener(new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                    View lastChild;
                    int lastPos = ConversationFragment.this.adapter.getCount() - 1;
                    if (lastPos > 0 && (lastChild = ConversationFragment.this.conversationList.getChildAt(lastPos)) != null) {
                        ConversationFragment.this.intercomLinkView.intersectsView(lastChild);
                    }
                }
            });
        }
        ImageView wallpaper = (ImageView)this.rootView.findViewById(R.id.wallpaper);
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), this.appIdentity);
        this.wallpaperLoader.loadWallpaperInto(wallpaper, new WallpaperLoader.Listener(){

            @Override
            public void onLoadComplete() {
                BackgroundUtils.setBackground(ConversationFragment.this.rootView, null);
            }
        });
        this.textComposer = (ComposerInputView)this.rootView.findViewById(R.id.composer_input_view);
        this.reactionComposer = (ReactionInputView)this.rootView.findViewById(R.id.reaction_input_view);
        this.setupComposer();
        this.listener.setToolbarBackground(17170445);
        this.listener.setToolbarTitle(null);
        this.listener.setCountVisible();
        this.listener.setStatusBarColor();
        this.globalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            private int previousHeight;

            public void onGlobalLayout() {
                int newHeight = ConversationFragment.this.rootView.getHeight();
                if (this.previousHeight != 0 && !ConversationFragment.this.orientationChanged && this.previousHeight > newHeight) {
                    int velocity = ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_close_velocity);
                    ConversationFragment.this.profileCoordinator.flingCoordinator(velocity);
                }
                if (ConversationFragment.this.orientationChanged && this.previousHeight != newHeight) {
                    ConversationFragment.this.orientationChanged = false;
                }
                this.previousHeight = newHeight;
                ConversationFragment.this.updateIntercomLink();
            }
        };
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        this.conversationList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && ConversationFragment.this.isAtBottom()) {
                    ConversationFragment.this.pill.setVisibility(8);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                ConversationFragment.this.updateIntercomLink();
            }
        });
        return this.rootView;
    }

    private void updateIntercomLink() {
        boolean isAtBottom = this.isAtBottom();
        if (this.shouldShowIntercomLink) {
            if (isAtBottom && !this.wasAtBottom) {
                this.intercomLinkView.show();
            } else if (this.wasAtBottom && !isAtBottom) {
                this.intercomLinkView.hide();
            }
            this.wasAtBottom = this.isAtBottom();
        }
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (this.conversationId.isEmpty()) {
            if (this.shouldShowIntercomLink) {
                this.intercomLinkView.show();
            }
            this.canOpenProfile = false;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getActivity() == null) {
                        return;
                    }
                    int velocity = ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity);
                    ConversationFragment.this.profileCoordinator.profileAutoOpened(velocity);
                    ConversationFragment.this.profileCoordinator.startOffsetListener();
                    ConversationFragment.this.conversationList.smoothScrollToPosition(0);
                }
            }, 50L);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (!this.hasLoadedConversation && !this.conversationId.isEmpty() && LastParticipatingAdmin.isNull(this.lastParticipant)) {
            this.profileCoordinator.setUnknownPresence();
        } else {
            this.updateProfileToolbar();
        }
        this.networkConnectivityListener.startListening((Context)this.getActivity());
        this.networkConnectivityListener.registerHandler(this.connectivityMonitor, 0);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.currentOrientation) {
            this.orientationChanged = true;
            this.textComposer.updateMaxLines();
        }
        this.currentOrientation = newConfig.orientation;
    }

    public void onStop() {
        super.onStop();
        this.networkConnectivityListener.unregisterHandler(this.connectivityMonitor);
        this.networkConnectivityListener.stopListening();
        this.profileCoordinator.onStop();
    }

    public void onDestroyView() {
        ViewUtils.removeGlobalLayoutListener(this.rootView, this.globalLayoutListener);
        this.bus.unregister((Object)this);
        View view = this.getView();
        if (view != null) {
            view.removeCallbacks(this.timestampUpdater);
        }
        this.textComposer.hideKeyboard();
        this.textComposer.cleanup();
        try {
            this.wallpaperLoader.close();
        }
        catch (IOException e) {
            IntercomLogger.d("Couldn't close LongTermImageLoader: " + e.getMessage());
        }
        super.onDestroyView();
    }

    public void sdkWindowFinishedAnimating() {
        if (this.shouldExpandProfile(this.conversation)) {
            this.profileCoordinator.profileAutoOpened(this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity));
            this.conversationList.smoothScrollToPosition(0);
        }
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void retryTapped() {
        if (this.markedPart == null) {
            return;
        }
        this.markedPart.setMessageState(Part.MessageState.SENDING);
        this.markedPart.setFooter(this.getString(R.string.intercom_sending));
        this.conversationParts.remove(this.markedPart);
        this.conversationParts.add(this.conversationParts.size(), this.markedPart);
        this.adapter.notifyDataSetChanged();
        String partText = this.markedPart.getBlocks().get(0).getText();
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversation(partText, this.markedPart.getId());
        } else {
            this.replyToConversation(partText, this.markedPart, this.conversationParts.size() - 1);
        }
        this.markedPart = null;
    }

    private void sendTapped() {
        String text = this.textComposer.getTrimmedText();
        if (!text.isEmpty()) {
            Part message = this.createSendingUi(text);
            this.soundPlayer.playReplySendingSound();
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversation(text, message.getId());
            } else {
                this.replyToConversation(text, message, this.conversationParts.size() - 1);
            }
            this.textComposer.clear();
            this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
        }
    }

    private void attachmentTapped() {
        if (DeviceUtils.hasPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") || Build.VERSION.SDK_INT < 19) {
            this.launchContentSelector();
        } else if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
        }
    }

    private Part getFirstMessagePart() {
        for (Part part : this.conversationParts) {
            if (!part.isMessagePart()) continue;
            return part;
        }
        return Part.NULL;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1) {
            if (grantResults[0] == 0) {
                this.launchContentSelector();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 == resultCode) {
            switch (requestCode) {
                case 1: {
                    Intent intent = new Intent((Context)this.getActivity(), AttachmentActivity.class);
                    intent.setData(data.getData());
                    this.startActivityForResult(intent, 2);
                    break;
                }
                case 2: {
                    this.uploadFile(data.getData(), "");
                    break;
                }
                default: {
                    IntercomLogger.internal("Unexpected request code");
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void launchContentSelector() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        this.startActivityForResult(intent, 1);
    }

    private void uploadFile(Uri uri, String id2) {
        if (uri != null) {
            new FileUploadTask(uri, id2, this.uploadingImageCache).execute(new Void[0]);
        }
    }

    private void setupComposer() {
        this.textComposer.requestInputFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.composerHolder.setVisibility(0);
            this.conversationList.setVisibility(0);
            this.textComposer.setHint(R.string.intercom_start_new_conversation);
            this.displayConversation();
        } else {
            this.textComposer.setConversationId(this.conversationId);
            this.api.getConversation(this.conversationId);
            this.displayLoadingView();
        }
    }

    private void displayLoadingView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.textComposer.setVisibility(8);
            this.loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
            this.conversationParts.add(0, this.loadingPart);
            this.adapter.notifyItemInserted(0);
        }
    }

    @VisibleForTesting
    protected void displayConversation() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.removeLoadingPart();
            this.configureInputView(this.conversation);
        }
    }

    private void displayErrorView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(0);
            this.composerHolder.setVisibility(8);
            this.removeLoadingPart();
        }
    }

    private void removeLoadingPart() {
        int index = this.conversationParts.indexOf(this.loadingPart);
        if (index != -1) {
            this.conversationParts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    private void startConversation(String text, String partId) {
        this.api.startNewConversation(text, this.conversationParts.size() - 1, partId);
    }

    private void startConversationWithAttachment(int uploadId, String partId) {
        this.api.startNewAttachmentConversation(uploadId, this.conversationParts.size() - 1, partId);
    }

    private void replyToConversation(String text, Part part, int partPosition) {
        this.api.textReply(this.conversationId, text, partPosition, part.getId());
    }

    private void attachmentToConversation(Part part, int partPosition, int uploadId) {
        this.api.attachmentReply(this.conversationId, uploadId, partPosition, part.getId());
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        this.composerHolder.setVisibility(0);
        int conversationSize = this.conversation.getParts().size();
        List<Part> eventParts = event.getResponse().getParts();
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.setupWithConversation();
            }
            if (!this.conversation.getRead().booleanValue()) {
                this.api.markConversationAsRead(this.conversationId);
                this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            }
            this.profileWillOpen = false;
            if (conversationSize == 0) {
                View view;
                if (this.canOpenProfile && (view = this.getView()) != null) {
                    view.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationFragment.this.getContext() == null) {
                                return;
                            }
                            ConversationFragment.this.profileWillOpen = ConversationFragment.this.shouldExpandProfile(ConversationFragment.this.conversation);
                            if (ConversationFragment.this.profileWillOpen) {
                                ConversationFragment.this.profileCoordinator.profileAutoOpened(ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity));
                                ConversationFragment.this.profileCoordinator.startOffsetListener();
                                ConversationFragment.this.conversationList.smoothScrollToPosition(0);
                            } else {
                                ConversationFragment.this.profileCoordinator.startOffsetListener();
                            }
                            if (ConversationFragment.this.profileWillOpen) {
                                ConversationFragment.this.conversationList.scrollToPosition(0);
                            } else {
                                ConversationFragment.this.conversationList.smoothScrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
                            }
                        }
                    }, 50L);
                    this.canOpenProfile = false;
                }
            } else {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part p : newParts) {
                    if (!p.isAdmin()) continue;
                    this.soundPlayer.playAdminReplySound();
                    break;
                }
                if (this.isAtBottom()) {
                    this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
                } else {
                    this.pill.setVisibility(0);
                }
                this.bus.post((Object)new CancelAdminTypingEvent());
                this.currentTypers.clear();
                Part lastPart = newParts.get(newParts.size() - 1);
                Injector.get().getMetricsStore().track(MetricFactory.receivedReply(lastPart.hasAttachments(), lastPart.getId(), this.conversationId));
            }
        }
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.adapter.setLastParticipatingAdmin(this.lastParticipant);
        this.updateLastActiveTime(this.conversation);
        this.updateProfileToolbar();
        this.hasLoadedConversation = true;
    }

    boolean shouldExpandProfile(Conversation conversation) {
        return this.hasOnlyUserParts(conversation) || this.hasNoUserReplies(conversation);
    }

    private boolean hasNoUserReplies(Conversation conversation) {
        boolean hasAdminPart = false;
        for (Part part : conversation.getParts()) {
            if (part.isAdmin()) {
                hasAdminPart = true;
            }
            if (!hasAdminPart || part.isAdmin()) continue;
            return false;
        }
        return true;
    }

    private boolean hasOnlyUserParts(Conversation conversation) {
        for (Part part : conversation.getParts()) {
            if (!part.isAdmin()) continue;
            return false;
        }
        return true;
    }

    private void updateLastActiveTime(long time) {
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null && this.getActivity() != null) {
            TimeFormatter timeFormatter = new TimeFormatter((Context)this.getActivity(), Injector.get().getTimeProvider());
            this.lastActiveTime = timeFormatter.getAdminActiveStatus(time);
        }
    }

    private void updateLastActiveTime(Conversation conversation) {
        LastParticipatingAdmin lastAdmin = conversation.getLastParticipatingAdmin();
        if (lastAdmin != null) {
            this.updateLastActiveTime(lastAdmin.getLastActiveAt());
        }
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && this.conversationParts != null && !this.conversationParts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                Part part = this.conversationParts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
        this.displayErrorView();
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.conversationParts.isEmpty() && this.conversationParts.get(this.conversationParts.size() - 1).getId().equals(event.getIdentifier())) {
            this.conversation = event.getResponse();
            this.conversationId = this.conversation.getId();
            this.profileCoordinator.setConversationId(this.conversationId);
            this.lastViewStore.setLastState(LastViewStore.State.CONVERSATION);
            this.lastViewStore.setLastViewedConversationId(this.conversationId);
            this.conversationParts.remove(this.conversationParts.size() - 1);
            this.sendingFailures.clear();
            Part part = event.getResponse().getParts().get(0);
            this.createMessageUi(part);
            this.conversationParts.add(part);
            this.textComposer.setConversationId(this.conversationId);
            this.nexusClient.fire(NexusEvent.getCreateConversationEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            this.soundPlayer.playReplySuccessSound();
            this.adapter.notifyDataSetChanged();
            Injector.get().getMetricsStore().track(MetricFactory.sentInNewConversation(part.hasAttachments(), part.getId(), this.conversationId));
            Injector.get().getMetricsStore().track(MetricFactory.startConversation(this.conversationId));
            this.hasLoadedConversation = true;
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            final Part part = event.getResponse();
            Participant participant = this.conversation.getParticipant(part.getParticipantId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(part.getParticipantId()).build();
                this.conversation.getParticipants().put(part.getParticipantId(), participant);
            }
            part.setParticipant(participant);
            int position = this.positionOfTempPart(event.getPosition(), event.getPartId());
            if (position >= 0) {
                this.sendingFailures.remove(this.conversationParts.remove(position));
            }
            this.createMessageUi(part);
            part.setDisplayDelivered(true);
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            this.soundPlayer.playReplySuccessSound();
            Injector.get().getMetricsStore().track(MetricFactory.sentInConversation(part.hasAttachments(), part.getId(), this.conversationId));
            this.postOnView(new Runnable(){

                @Override
                public void run() {
                    part.setDisplayDelivered(false);
                    ConversationFragment.this.adapter.notifyDataSetChanged();
                }
            }, PART_DISPLAY_DELIVERED_TIMEOUT);
        }
    }

    void postOnView(Runnable action, long delayMillis) {
        View view = this.getView();
        if (view != null) {
            view.postDelayed(action, delayMillis);
        }
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.soundPlayer.playReplyFailSound();
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        int partPosition = this.positionOfTempPart(event.getTempPartPosition(), event.getTempPartId());
        if (partPosition >= 0) {
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversationWithAttachment(event.getUploadId(), event.getTempPartId());
            } else {
                this.attachmentToConversation(this.conversationParts.get(partPosition), partPosition, event.getUploadId());
            }
        }
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.soundPlayer.playReplyFailSound();
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfTempPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.conversationParts.get(partPosition);
            UploadProgressListener listener = (UploadProgressListener)this.getLayoutForPart(failedPart).getChildAt(0);
            listener.uploadStopped();
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            failedPart.setFooter(this.getString(R.string.intercom_sending_failure));
            this.adapter.notifyDataSetChanged();
        }
    }

    private ViewGroup getLayoutForPart(Part part) {
        return this.adapter.getLayoutForPart(part);
    }

    private int positionOfTempPart(int position, String partId) {
        if (position >= 0 && position < this.conversationParts.size()) {
            Part sendingPart = this.conversationParts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                if (!this.conversationParts.get(i).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setupWithConversation() {
        this.textComposer.setHint(R.string.intercom_reply_to_conversation);
        this.createConversationUi(this.conversation.getParts());
        this.postOnView(this.timestampUpdater, TIMESTAMP_UPDATE_PERIOD);
    }

    private void configureInputView(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (ReactionReply.isNull(lastPart.getReactionReply())) {
            this.textComposer.setVisibility(0);
            this.reactionComposer.setVisibility(8);
            this.textComposer.requestInputFocus();
        } else {
            this.reactionComposer.setUpReactions(lastPart.getReactionReply(), conversation.getId(), lastPart.getId(), ReactionInputView.ReactionLocation.CONVERSATION, true);
            this.textComposer.setVisibility(8);
        }
    }

    private void createConversationUi(List<Part> parts) {
        this.conversationParts.clear();
        for (Part part : parts) {
            if (this.getLayoutForPart(part) == null) {
                this.createMessageUi(part);
            }
            this.conversationParts.add(this.conversationParts.size(), part);
        }
        this.conversationParts.addAll(this.sendingFailures);
        this.timestampAdder.addDayDividers(this.conversationParts);
        this.adapter.notifyDataSetChanged();
        this.displayConversation();
    }

    public void toggleProfile() {
        if (this.profileCoordinator.isExpanded()) {
            int velocity = this.getResources().getDimensionPixelSize(R.dimen.intercom_close_velocity);
            this.profileCoordinator.flingCoordinator(velocity);
        } else {
            int velocity = this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity);
            this.profileCoordinator.profileClicked(velocity);
            this.conversationList.smoothScrollToPosition(0);
        }
    }

    private Part createSendingUi(String text) {
        String textAfterServerProcessing = text.replace("\n", " <br>");
        Block block = new Block.Builder().withText(textAfterServerProcessing).withType(BlockType.PARAGRAPH.name()).build();
        List<Block> blockParts = Collections.singletonList(block);
        Part part = new Part();
        part.setMessageStyle("chat");
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setBlocks(blockParts);
        part.setFooter(this.getString(R.string.intercom_sending));
        part.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis()));
        this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        part.setEntranceAnimation(true);
        part.setShowCreatedAt(true);
        this.conversationParts.add(this.conversationParts.size(), part);
        this.sendingFailures.add(part);
        this.adapter.notifyDataSetChanged();
        return part;
    }

    private void setLayoutForBlock(Part part, ViewGroup blocks) {
        this.adapter.setLayoutForBlock(part, blocks);
    }

    private void updateProfileToolbar() {
        if (LastParticipatingAdmin.isNull(this.lastParticipant) || this.lastParticipant == LastParticipatingAdmin.NONE) {
            this.showTeamPresence();
        } else {
            this.updateLastActiveTime(this.lastParticipant.getLastActiveAt());
            this.profileCoordinator.setTeammatePresence(this.lastParticipant, this.lastActiveTime, this.getActivity().getWindow().getDecorView().getMeasuredWidth());
        }
    }

    private Participant getUserParticipant() {
        String intercomId = this.userIdentity.getIntercomId();
        Participant user = this.conversation.getParticipant(intercomId);
        if (Participant.isNull(user)) {
            user = new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.api.getConversation(this.conversationId);
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId()) && !this.currentTypers.contains(event.getAdminId())) {
            Part isTypingPart = new Part();
            Participant participant = this.conversation.getParticipant(event.getAdminId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(event.getAdminId()).withName(event.getAdminName()).withAvatar(new Avatar.Builder().withImageUrl(event.getAdminAvatarUrl())).withType("admin").build();
            }
            isTypingPart.setParticipantIsAdmin(true);
            isTypingPart.setParticipant(participant);
            isTypingPart.setMessageStyle("admin_is_typing_style");
            isTypingPart.setEntranceAnimation(true);
            LinearLayout contentLayout = (LinearLayout)View.inflate((Context)this.getActivity(), (int)R.layout.intercom_blocks_admin_layout, null);
            AdminIsTypingView adminIsTypingView = new AdminIsTypingView((Context)this.getActivity(), event.getAdminId(), this.conversationId, isTypingPart.getId());
            contentLayout.addView((View)adminIsTypingView);
            this.setLayoutForBlock(isTypingPart, (ViewGroup)contentLayout);
            boolean wasAtBottom = this.isAtBottom();
            int index = this.conversationParts.isEmpty() ? 0 : this.conversationParts.size();
            this.conversationParts.add(index, isTypingPart);
            this.adapter.notifyDataSetChanged();
            this.currentTypers.add(event.getAdminId());
            if (wasAtBottom) {
                this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
            }
        }
    }

    @Subscribe
    public void adminIsntTyping(AdminTypingEndedEvent event) {
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, event.getPartId());
        if (position >= 0) {
            this.currentTypers.remove(event.getAdminId());
            this.conversationParts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void sendMessage(SendingEvent event) {
        if (event.isAttachment()) {
            this.attachmentTapped();
        } else {
            this.sendTapped();
        }
    }

    private boolean isAtBottom() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.conversationParts.size() - 1;
    }

    @Override
    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.markedPart = part;
            this.listener.showErrorMessageDialog();
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            part.setMessageState(Part.MessageState.SENDING);
            part.setFooter(this.getString(R.string.intercom_sending));
            this.conversationParts.remove(this.conversationParts.indexOf(part));
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            this.uploadFile(part.getFileUri(), part.getId());
        }
    }

    private void showTeamPresence() {
        CharSequence title = Phrase.from(this.getContext(), R.string.intercom_team).put("name", this.appIdentity.getAppConfig().getName()).format();
        this.profileCoordinator.setTeamCollapsingTitle(title);
        if (this.teamPresenceProvider.hasTeamPresence()) {
            this.profileCoordinator.setTeamPresence(this.teamPresenceProvider.getTeamPresence(), this.getActivity().getWindow().getDecorView().getMeasuredWidth());
        } else {
            this.profileCoordinator.hideTeammateSubtitle();
        }
    }

    @Override
    public void onSupportAttach(Context context) {
        super.onSupportAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationFragment.Listener");
        }
    }

    private void createMessageUi(Part part) {
        Participant user;
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).withContentType(attachment.getContentType()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if ("user".equals((user = part.getParticipant()).getType()) && user.getId().equals(this.userIdentity.getIntercomId())) {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else {
            this.setLayoutForBlock(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
    }

    public static interface Listener {
        public void setToolbarTitle(String var1);

        public void setToolbarBackground(@ColorRes int var1);

        public void showErrorMessageDialog();

        public void setCountVisible();

        public void setStatusBarColor();
    }

    private class FileUploadTask
    extends AsyncTask<Void, Void, AttachmentData> {
        private static final String IMAGE_MIME_TYPE = "image";
        private final Uri uri;
        private final String id;
        private final UploadingImageCache uploadingImageCache;

        FileUploadTask(Uri uri, String id2, UploadingImageCache uploadingImageCache) {
            this.uri = uri;
            this.id = id2;
            this.uploadingImageCache = uploadingImageCache;
        }

        protected AttachmentData doInBackground(Void ... params) {
            return new AttachmentData(this.uri, this.id, ConversationFragment.this.getContext());
        }

        protected void onPostExecute(AttachmentData data) {
            UploadProgressListener listener;
            String id2 = data.getId();
            if (id2.isEmpty()) {
                Part uploadingPart = this.createUploadingPart(data);
                ConversationFragment.this.soundPlayer.playReplySendingSound();
                id2 = uploadingPart.getId();
                listener = (UploadProgressListener)ConversationFragment.this.getLayoutForPart(uploadingPart).getChildAt(0);
            } else {
                int i = ConversationFragment.this.positionOfTempPart(ConversationFragment.this.conversationParts.size() - 1, id2);
                if (i >= 0) {
                    listener = (UploadProgressListener)ConversationFragment.this.getLayoutForPart((Part)ConversationFragment.this.conversationParts.get(i)).getChildAt(0);
                    listener.uploadStarted();
                } else {
                    listener = new UploadProgressListener(){

                        @Override
                        public void uploadStarted() {
                        }

                        @Override
                        public void uploadNotice(byte percentUploaded) {
                        }

                        @Override
                        public void uploadStopped() {
                        }
                    };
                }
            }
            ConversationFragment.this.api.uploadFile(data, ConversationFragment.this.conversationParts.size() - 1, id2, this.uploadingImageCache, listener);
        }

        private Part createUploadingPart(AttachmentData attachment) {
            ArrayList<Block> blockParts = new ArrayList<Block>();
            Part part = new Part();
            if (attachment.getMimeType().contains(IMAGE_MIME_TYPE)) {
                Block block = new Block.Builder().withUrl(attachment.getPath()).withType(BlockType.LOCALIMAGE.name()).withWidth(attachment.getImageWidth()).withHeight(attachment.getImageHeight()).build();
                blockParts.add(block);
                part.isImageOnly(true);
            } else {
                BlockAttachment blockAttachment = new BlockAttachment.Builder().withName(attachment.getFileName()).withUrl(attachment.getPath()).withContentType(attachment.getMimeType()).build();
                Block block = new Block.Builder().withAttachments(Collections.singletonList(blockAttachment)).withType(BlockType.LOCAL_ATTACHMENT.name()).build();
                blockParts.add(block);
            }
            part.setMessageStyle("chat");
            part.setMessageState(Part.MessageState.SENDING);
            part.setParticipant(ConversationFragment.this.getUserParticipant());
            part.setBlocks(blockParts);
            part.setFooter(ConversationFragment.this.getString(R.string.intercom_sending));
            part.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis()));
            part.setEntranceAnimation(true);
            part.setShowCreatedAt(true);
            ConversationFragment.this.setLayoutForBlock(part, (ViewGroup)ConversationFragment.this.blocks.createBlocks(blockParts, ConversationFragment.this.generator.getPreviewHolder()));
            part.setFileUri(attachment.getUri());
            ConversationFragment.this.conversationParts.add(ConversationFragment.this.conversationParts.size(), part);
            ConversationFragment.this.sendingFailures.add(part);
            ConversationFragment.this.adapter.notifyDataSetChanged();
            ConversationFragment.this.conversationList.smoothScrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
            return part;
        }
    }
}

