/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;

public class UploadProgressBar
extends View {
    private static final int MAX = 100;
    private static final int STROKE_WIDTH = 8;
    private static final int START_ANGLE = -90;
    private RectF rectF = new RectF();
    private Paint backgroundPaint = new Paint(1);
    private Paint foregroundPaint;
    private int progress = 0;

    public UploadProgressBar(Context context) {
        this(context, null);
    }

    public UploadProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.backgroundPaint.setColor(-2013265920);
        this.backgroundPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.backgroundPaint.setStrokeWidth(8.0f);
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(-1);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(8.0f);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.smoothStartAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hideBar();
    }

    public void setProgress(int progress) {
        IntercomLogger.internal("animation", "received progress of  " + progress);
        if (progress > this.progress) {
            this.progress = progress;
            this.invalidate();
        }
    }

    public void hideBar() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float angle = 360 * this.progress / 100;
        canvas.drawOval(this.rectF, this.backgroundPaint);
        canvas.drawArc(this.rectF, -90.0f, angle, false, this.foregroundPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = UploadProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = UploadProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        this.rectF.set(4.0f, 4.0f, (float)(min - 4), (float)(min - 4));
    }

    private void smoothStartAnimation() {
        IntercomLogger.internal("animation", "starting upload start animation");
        ObjectAnimator animator2 = ObjectAnimator.ofInt((Object)((Object)this), (String)"progress", (int[])new int[]{0, 10});
        animator2.setDuration(1000L);
        animator2.start();
    }

    public void smoothEndAnimation() {
        ObjectAnimator animator2 = this.getObjectAnimator();
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                UploadProgressBar.this.hideBar();
            }
        });
        animator2.start();
    }

    public void smoothEndAnimation(Animator.AnimatorListener is) {
        ObjectAnimator animator2 = this.getObjectAnimator();
        animator2.addListener(is);
        animator2.start();
    }

    private ObjectAnimator getObjectAnimator() {
        IntercomLogger.internal("animation", "starting upload end animation");
        return ObjectAnimator.ofInt((Object)((Object)this), (String)"progress", (int[])new int[]{90, 99}).setDuration(1000L);
    }
}

