/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.annotation.LayoutRes;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.ListBlock;
import io.intercom.android.sdk.blocks.LocalImage;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.CodeBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.FacebookBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalAttachmentBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.TwitterBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Part;
import java.util.ArrayList;
import java.util.List;

public class ViewHolderGenerator {
    private final Context context;
    private final UploadingImageCache uploadingImageCache;

    public ViewHolderGenerator(Context context, UploadingImageCache uploadingImageCache) {
        this.context = context;
        this.uploadingImageCache = uploadingImageCache;
    }

    public BlocksViewHolder getAdminHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.ADMIN);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.USER);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.PREVIEW);
    }

    public BlocksViewHolder getPostHolder() {
        return this.generateHolder(R.layout.intercom_blocks_post_layout, StyleType.POST);
    }

    public BlocksViewHolder getNoteHolder() {
        return this.generateHolder(R.layout.intercom_blocks_note_layout, StyleType.NOTE);
    }

    public BlocksViewHolder getContainerCardHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_card_layout, StyleType.CONTAINER_CARD);
    }

    public BlocksViewHolder getChatFullHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.CHAT_FULL);
    }

    private BlocksViewHolder generateHolder(@LayoutRes int layoutId, StyleType style) {
        BlocksViewHolder holder = new BlocksViewHolder();
        Button button = new Button(this.context, style);
        Heading heading = new Heading(this.context, style);
        ListBlock list = new ListBlock(this.context, style);
        Attachment attachment = new Attachment(this.context, style);
        holder.setLayout(layoutId);
        holder.setParagraph((ParagraphBlock)new Paragraph(this.context, style));
        holder.setHeading((HeadingBlock)heading);
        holder.setSubheading((SubheadngBlock)heading);
        holder.setCode((CodeBlock)new Code(this.context, style));
        holder.setUnorderedList((UnorderedListBlock)list);
        holder.setOrderedList((OrderedListBlock)list);
        holder.setImage((ImageBlock)new NetworkImage(this.context, style, this.uploadingImageCache));
        holder.setLocalImage((LocalImageBlock)new LocalImage(this.context, style));
        holder.setButton((ButtonBlock)button);
        holder.setAttachmentList((AttachmentListBlock)attachment);
        holder.setLocalAttachment((LocalAttachmentBlock)attachment);
        holder.setTwitterButton((TwitterBlock)button);
        holder.setFacebookButton((FacebookBlock)button);
        holder.setVideo((VideoBlock)new Video(this.context, style));
        return holder;
    }

    public static void createPartUi(BlocksViewHolder blocksNoteViewHolder, Part part, Context context) {
        List<Block> blockParts = part.getBlocks();
        Blocks blocks = new Blocks(context);
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if (!blockParts.isEmpty()) {
            part.setLayout(blocks.createBlocks(blockParts, blocksNoteViewHolder));
        }
    }
}

