/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.TimeUtils;

public class PartMetadataFormatter {
    private final TextView metadataTextView;
    private final Context context;
    private final String sendingText;
    private final String deliveredText;
    private final String failedText;
    private final String seenText;
    private final String unseenText;

    public static PartMetadataFormatter create(TextView metadataTextView, Context context) {
        String sendingText = context.getResources().getString(R.string.intercom_sending);
        String deliveredText = context.getResources().getString(R.string.intercom_delivered);
        String seenText = context.getResources().getString(R.string.intercom_message_seen);
        String unseenText = context.getResources().getString(R.string.intercom_message_unseen);
        String failedText = context.getResources().getString(R.string.intercom_message_failed_try_again);
        return new PartMetadataFormatter(metadataTextView, context, sendingText, deliveredText, failedText, seenText, unseenText);
    }

    PartMetadataFormatter(TextView metadataTextView, Context context, String sendingText, String deliveredText, String failedText, String seenText, String unseenText) {
        this.metadataTextView = metadataTextView;
        this.context = context;
        this.sendingText = sendingText;
        this.deliveredText = deliveredText;
        this.failedText = failedText;
        this.seenText = seenText;
        this.unseenText = unseenText;
    }

    @Nullable
    public String getMetadataString(int type, Part conversationPart, boolean isLastItem) {
        switch (conversationPart.getMessageState()) {
            case SENDING: {
                return this.sendingText;
            }
            case FAILED: 
            case UPLOAD_FAILED: {
                return this.failedText;
            }
        }
        if (type == 2 || type == 3) {
            this.metadataTextView.setVisibility(4);
            this.metadataTextView.setHeight(ScreenUtils.convertDpToPixel((float)10.0f, (Context)this.context));
            return null;
        }
        if (isLastItem) {
            return this.formatLastPart(conversationPart);
        }
        return this.formatPart(conversationPart);
    }

    @NonNull
    String formatLastPart(Part conversationPart) {
        StringBuilder sb = new StringBuilder();
        if (conversationPart.isDisplayDelivered()) {
            sb.append(this.deliveredText);
        } else {
            sb.append(TimeUtils.getFormattedTime(conversationPart.getCreatedAt(), this.context.getResources()));
        }
        if ("seen".equalsIgnoreCase(conversationPart.getSeenByAdmin())) {
            sb.append(". ").append(this.seenText);
        } else if ("unseen".equalsIgnoreCase(conversationPart.getSeenByAdmin())) {
            sb.append(". ").append(this.unseenText);
        }
        return sb.toString();
    }

    @NonNull
    String formatPart(Part conversationPart) {
        return conversationPart.isDisplayDelivered() ? "" : TimeUtils.getAbsoluteTime(conversationPart.getCreatedAt());
    }
}

