/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.res.Resources;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Location;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class LocationFormatter {
    public static String getLocationString(Resources resources, Location location, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("h:mma", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone(location.getTimezone()));
        DateFormatSymbols symbols = new DateFormatSymbols(Locale.getDefault());
        symbols.setAmPmStrings(new String[]{"am", "pm"});
        dateFormat.setDateFormatSymbols(symbols);
        return resources.getString(R.string.intercom_profile_location, new Object[]{String.format(Locale.getDefault(), "%s", dateFormat.format(date)), location.getCityName(), location.getCountryName()});
    }
}

