/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.user;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DeviceData {
    private static final String PREFS_DEVICE_ID = "DeviceId";
    private static final String PREFS_PUSH_TOKEN = "push_token";

    public static Map<String, Object> generateDeviceData(Context context) {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        deviceData.put("platform_version", Build.VERSION.RELEASE);
        deviceData.put("device", Build.CPU_ABI);
        deviceData.put("platform", Build.MODEL);
        deviceData.put("browser", "Intercom-Android-SDK");
        deviceData.put("version", DeviceUtils.getAppVersion((Context)context));
        deviceData.put("application", DeviceUtils.getAppName((Context)context));
        deviceData.put("language", Locale.getDefault().getDisplayLanguage());
        deviceData.put("device_id", DeviceData.getCachedOrNewId(context));
        String token = DeviceData.getPreferences(context).getString(PREFS_PUSH_TOKEN, "");
        if (!token.isEmpty()) {
            deviceData.put("device_token", token);
        }
        return deviceData;
    }

    public static boolean hasCachedPushToken(Context context, String pushToken) {
        return pushToken.equals(DeviceData.getPushToken(context));
    }

    public static void cachePushToken(Context context, String pushToken) {
        DeviceData.getPreferences(context).edit().putString(PREFS_PUSH_TOKEN, pushToken).apply();
    }

    public static String getPushToken(Context context) {
        return DeviceData.getPreferences(context).getString(PREFS_PUSH_TOKEN, "");
    }

    private static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
    }

    private static String getCachedOrNewId(Context context) {
        SharedPreferences prefs = DeviceData.getPreferences(context);
        String uuid = prefs.getString(PREFS_DEVICE_ID, "");
        if (uuid.isEmpty()) {
            uuid = DeviceUtils.generateDeviceId((Context)context);
            prefs.edit().putString(PREFS_DEVICE_ID, uuid).apply();
        }
        return uuid;
    }
}

