/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.store.HasConversationsStore;
import io.intercom.android.sdk.store.LastViewStore;
import io.intercom.android.sdk.store.UnreadConversationIdsStore;
import java.util.Set;

public class LauncherOpenBehaviour {
    private final AppConfig.Provider appConfigProvider;
    private final UnreadConversationIdsStore unreadConversationIdsStore;
    private final HasConversationsStore hasConversationsStore;
    private final LastViewStore lastViewStore;

    public LauncherOpenBehaviour(AppConfig.Provider appConfigProvider, UnreadConversationIdsStore unreadConversationIdsStore, HasConversationsStore hasConversationsStore, LastViewStore lastViewStore) {
        this.appConfigProvider = appConfigProvider;
        this.unreadConversationIdsStore = unreadConversationIdsStore;
        this.hasConversationsStore = hasConversationsStore;
        this.lastViewStore = lastViewStore;
    }

    public void openMessenger(Context context) {
        Set<String> unreadConversationIds = this.unreadConversationIdsStore.getConversationIds();
        if (unreadConversationIds.size() == 1) {
            this.presentConversation(context, unreadConversationIds.iterator().next());
        } else if (unreadConversationIds.size() > 1) {
            this.presentInbox(context);
        } else {
            this.openLastOrDefaultState(context);
        }
    }

    private void openLastOrDefaultState(Context context) {
        LastViewStore.State lastState = this.lastViewStore.getLastState();
        if (lastState == null) {
            if (this.hasEmptyInbox() && this.appConfigProvider.getAppConfig().isInboundMessages()) {
                this.presentComposer(context);
            } else {
                this.presentInbox(context);
            }
        } else {
            switch (lastState) {
                case CONVERSATION: {
                    String lastViewedConversationId = this.lastViewStore.getLastViewedConversationId();
                    if (TextUtils.isEmpty((CharSequence)lastViewedConversationId)) {
                        this.presentInbox(context);
                        break;
                    }
                    this.presentConversation(context, lastViewedConversationId);
                    break;
                }
                default: {
                    this.presentInbox(context);
                    break;
                }
                case COMPOSER: {
                    this.presentComposer(context);
                }
            }
        }
    }

    private boolean hasEmptyInbox() {
        return !this.hasConversationsStore.hasConversations() && this.unreadConversationIdsStore.getConversationIds().isEmpty();
    }

    private void presentConversation(Context context, String conversationId) {
        LastParticipatingAdmin unknownAdmin = LastParticipatingAdmin.NULL;
        context.startActivity(IntercomMessengerActivity.openConversation(context, conversationId, unknownAdmin));
    }

    private void presentComposer(Context context) {
        context.startActivity(IntercomMessengerActivity.openComposer(context));
    }

    private void presentInbox(Context context) {
        context.startActivity(IntercomMessengerActivity.openInbox(context));
    }
}

