/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.photoview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.photoview.Compat;
import io.intercom.android.sdk.photoview.DefaultOnDoubleTapListener;
import io.intercom.android.sdk.photoview.IPhotoView;
import io.intercom.android.sdk.photoview.gestures.GestureDetectorImpl;
import io.intercom.android.sdk.photoview.gestures.OnGestureListener;
import io.intercom.android.sdk.photoview.scrollerproxy.ScrollerProxy;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import java.lang.ref.WeakReference;

public class PhotoViewAttacher
implements IPhotoView,
View.OnTouchListener,
OnGestureListener,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final Interpolator INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static int ZOOM_DURATION = 200;
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    private static final int TRANSLATION_THRESHOLD = 10;
    private static final int ROTATION_CLAMP = 6;
    private static final int ROTATION_DAMPENER = 100;
    private static final int TRANSLATION_DAMPENER = 8;
    private static float minScale = 1.0f;
    private static float midScale = 1.75f;
    private static float mMaxScale = 3.0f;
    private boolean allowParentInterceptOnEdge = true;
    private boolean blockParentIntercept = false;
    private static final int OPAQUE_ALPHA = 255;
    private static final int MIN_ALPHA = 50;
    private static final int IMAGE_PADDING_DP = 20;
    private static final int DISMISS_DISTANCE_DP = 20;
    private static final int ORIGINAL_ZOOM_DISTANCE_PIXELS = 60;
    private SpringSystem springSystem = SpringSystem.create();
    private SpringConfig xyExpandSpringConfig = new SpringConfig(100.0, 70.0);
    private SpringConfig xyShrinkSpringConfig = new SpringConfig(350.0, 50.0);
    private SpringConfig scaleExpandSpringConfig = new SpringConfig(500.0, 100.0);
    private SpringConfig scaleShrinkSpringConfig = new SpringConfig(400.0, 40.0);
    private SpringConfig alphaShrinkSpringConfig = new SpringConfig(300.0, 50.0);
    private SpringConfig springConfig = new SpringConfig(400.0, 40.0);
    private final Spring xPositionSpring = this.springSystem.createSpring();
    private final Spring yPositionSpring = this.springSystem.createSpring();
    private final Spring scaleSpring = this.springSystem.createSpring();
    private final Spring alphaSpring = this.springSystem.createSpring();
    private final Spring rotationSpring = this.springSystem.createSpring();
    private WeakReference<ImageView> imageView;
    private GestureDetector gestureDetector;
    private GestureDetectorImpl scaleDragDetector;
    private final Matrix baseMatrix = new Matrix();
    private final Matrix drawMatrix = new Matrix();
    private final Matrix suppMatrix = new Matrix();
    private final RectF displayRect = new RectF();
    private final float[] matrixValues = new float[9];
    private OnMatrixChangedListener matrixChangeListener;
    private View.OnLongClickListener longClickListener;
    private OnScaleChangeListener scaleChangeListener;
    private int imageViewTop;
    private int imageViewRight;
    private int imageViewBottom;
    private int imageViewLeft;
    private FlingRunnable currentFlingRunnable;
    private int scrollEdge = 2;
    private int scrollEdgeTopBottom = 2;
    private boolean zoomEnabled;
    private ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_CENTER;
    private int currentImageAlpha;
    private int statusBarHeight;
    private float scaleFactor;
    private float originalXCoordinate;
    private float originalYCoordinate;
    private float finalXCoordinate;
    private float finalYCoordinate;
    private View blackOverlayView;
    private ImageView originalImageView;
    private FrameLayout iamContainer;
    private DisplayMetrics displayMetrics;
    private boolean finishedRotating = true;
    private boolean finishedScaling = true;
    private boolean finishedMovingX = true;
    private boolean finishedMovingY = true;

    private static void checkZoomLevels(float minZoom, float midZoom, float maxZoom) {
        if (minZoom >= midZoom) {
            throw new IllegalArgumentException("MinZoom has to be less than MidZoom");
        }
        if (midZoom >= maxZoom) {
            throw new IllegalArgumentException("MidZoom has to be less than MaxZoom");
        }
    }

    private static boolean hasDrawable(ImageView imageView) {
        return null != imageView && null != imageView.getDrawable();
    }

    private static boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (null == scaleType) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    private static void setImageViewScaleTypeMatrix(ImageView imageView) {
        if (null != imageView && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            imageView.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    private int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private ImageView animateImageLoadIn() {
        this.calculateDimensions();
        this.currentImageAlpha = 255;
        this.xPositionSpring.setSpringConfig(this.xyExpandSpringConfig);
        this.yPositionSpring.setSpringConfig(this.xyExpandSpringConfig);
        this.scaleSpring.setSpringConfig(this.scaleExpandSpringConfig);
        this.alphaSpring.setSpringConfig(this.springConfig);
        this.rotationSpring.setSpringConfig(this.springConfig);
        this.iamContainer = (FrameLayout)this.originalImageView.getRootView().findViewById(R.id.iam_container);
        int screenPadding = Math.round(20.0f * this.displayMetrics.density);
        final ImageView lightboxImageView = new ImageView(this.originalImageView.getContext());
        lightboxImageView.setImageDrawable(this.originalImageView.getDrawable());
        lightboxImageView.setX(this.originalXCoordinate);
        lightboxImageView.setY(this.originalYCoordinate);
        lightboxImageView.setScaleX(this.scaleFactor);
        lightboxImageView.setPivotX(0.0f);
        lightboxImageView.setPivotY(0.0f);
        lightboxImageView.setId(R.id.lightbox_image);
        lightboxImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        lightboxImageView.setPadding(screenPadding, screenPadding, screenPadding, screenPadding);
        lightboxImageView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.blackOverlayView = new View(this.originalImageView.getContext());
        this.blackOverlayView.setBackgroundResource(R.color.intercom_transparent_black_lightbox);
        this.blackOverlayView.getBackground().setAlpha(0);
        this.blackOverlayView.setId(R.id.lightbox_overlay);
        this.blackOverlayView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.iamContainer.addView(this.blackOverlayView);
        this.iamContainer.addView((View)lightboxImageView);
        this.finalXCoordinate = this.originalImageView.getX();
        this.finalYCoordinate = this.originalImageView.getY();
        this.finishedRotating = true;
        this.finishedMovingX = true;
        this.finishedMovingY = true;
        this.finishedScaling = true;
        this.xPositionSpring.removeAllListeners();
        this.xPositionSpring.setCurrentValue((double)this.originalXCoordinate);
        this.xPositionSpring.setEndValue((double)this.finalXCoordinate);
        this.xPositionSpring.setRestDisplacementThreshold(10.0);
        this.xPositionSpring.setRestSpeedThreshold(10.0);
        this.xPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedMovingX = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                lightboxImageView.setX((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedMovingX = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.introCompleted(lightboxImageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.yPositionSpring.removeAllListeners();
        this.yPositionSpring.setCurrentValue((double)this.originalYCoordinate);
        this.yPositionSpring.setEndValue((double)this.finalYCoordinate);
        this.yPositionSpring.setRestDisplacementThreshold(10.0);
        this.yPositionSpring.setRestSpeedThreshold(10.0);
        this.yPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedMovingY = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                lightboxImageView.setY((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedMovingY = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.introCompleted(lightboxImageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.scaleSpring.removeAllListeners();
        this.scaleSpring.setCurrentValue((double)this.scaleFactor);
        this.scaleSpring.setEndValue(1.0);
        this.scaleSpring.setRestDisplacementThreshold((double)0.1f);
        this.scaleSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedScaling = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                lightboxImageView.setScaleX((float)spring.getCurrentValue());
                lightboxImageView.setScaleY((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedScaling = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.introCompleted(lightboxImageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.alphaSpring.removeAllListeners();
        this.alphaSpring.setCurrentValue(0.0);
        this.alphaSpring.setEndValue(255.0);
        this.alphaSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                PhotoViewAttacher.this.blackOverlayView.getBackground().setAlpha((int)Math.round(spring.getCurrentValue()));
            }
        });
        this.originalImageView.setVisibility(4);
        this.xPositionSpring.setSpringConfig(this.springConfig);
        this.yPositionSpring.setSpringConfig(this.springConfig);
        this.scaleSpring.setSpringConfig(this.springConfig);
        return lightboxImageView;
    }

    public void dismiss() {
        final ImageView imageView = this.getImageView();
        imageView.setPivotX(0.0f);
        imageView.setPivotY(0.0f);
        this.finishedRotating = true;
        this.finishedMovingX = true;
        this.finishedMovingY = true;
        this.finishedScaling = true;
        this.xPositionSpring.setSpringConfig(this.xyShrinkSpringConfig);
        this.yPositionSpring.setSpringConfig(this.xyShrinkSpringConfig);
        this.scaleSpring.setSpringConfig(this.scaleShrinkSpringConfig);
        this.alphaSpring.setSpringConfig(this.alphaShrinkSpringConfig);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        imageView.setPadding(0, 0, 0, 0);
        this.calculateDimensions();
        imageView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.rotationSpring.removeAllListeners();
        this.rotationSpring.setCurrentValue((double)imageView.getRotation());
        this.rotationSpring.setEndValue(0.0);
        this.rotationSpring.setRestDisplacementThreshold(1.0);
        this.rotationSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedRotating = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                imageView.setRotation((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedRotating = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.dismissCompleted(imageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.xPositionSpring.removeAllListeners();
        this.xPositionSpring.setCurrentValue((double)imageView.getX());
        this.xPositionSpring.setEndValue((double)this.originalXCoordinate);
        this.xPositionSpring.setRestDisplacementThreshold(10.0);
        this.xPositionSpring.setRestSpeedThreshold(10.0);
        this.xPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedMovingX = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                imageView.setX((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedMovingX = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.dismissCompleted(imageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.yPositionSpring.removeAllListeners();
        this.yPositionSpring.setCurrentValue((double)imageView.getY());
        this.yPositionSpring.setEndValue((double)(this.originalYCoordinate - (float)this.statusBarHeight));
        this.yPositionSpring.setRestDisplacementThreshold(10.0);
        this.yPositionSpring.setRestSpeedThreshold(10.0);
        this.yPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedMovingY = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                imageView.setY((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedMovingY = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.dismissCompleted(imageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.scaleSpring.removeAllListeners();
        this.scaleSpring.setCurrentValue((double)imageView.getScaleX());
        this.scaleSpring.setEndValue((double)this.scaleFactor);
        this.scaleSpring.setRestDisplacementThreshold((double)0.1f);
        this.scaleSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                PhotoViewAttacher.this.finishedScaling = false;
                super.onSpringActivate(spring);
            }

            public void onSpringUpdate(Spring spring) {
                imageView.setScaleX((float)spring.getCurrentValue());
                imageView.setScaleY((float)spring.getCurrentValue());
            }

            public void onSpringAtRest(Spring spring) {
                PhotoViewAttacher.this.finishedScaling = true;
                if (PhotoViewAttacher.this.areAllListenersCompleted()) {
                    PhotoViewAttacher.this.dismissCompleted(imageView);
                }
                super.onSpringAtRest(spring);
            }
        });
        this.alphaSpring.removeAllListeners();
        this.alphaSpring.setCurrentValue((double)this.currentImageAlpha);
        this.alphaSpring.setEndValue(0.0);
        this.alphaSpring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                PhotoViewAttacher.this.blackOverlayView.getBackground().setAlpha((int)Math.round(spring.getCurrentValue()));
            }
        });
    }

    private boolean areAllListenersCompleted() {
        return this.finishedScaling && this.finishedRotating && this.finishedMovingX && this.finishedMovingY;
    }

    private void introCompleted(ImageView imageView) {
        imageView.setPivotX((float)(imageView.getWidth() / 2));
        imageView.setPivotY((float)(imageView.getHeight() / 2));
    }

    private void dismissCompleted(ImageView imageView) {
        this.originalImageView.setVisibility(0);
        this.originalImageView.setId(R.id.not_active_image);
        this.iamContainer.removeView((View)imageView);
        this.iamContainer.removeView(this.blackOverlayView);
    }

    private void calculateDimensions() {
        int[] pos = new int[2];
        this.originalImageView.getLocationOnScreen(pos);
        int startWidth = this.originalImageView.getWidth();
        int startHeight = this.originalImageView.getHeight();
        this.originalXCoordinate = Math.round(pos[0]);
        this.originalYCoordinate = Math.round(pos[1]);
        Point screen = new Point();
        Context context = this.originalImageView.getContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getSize(screen);
        this.displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(this.displayMetrics);
        this.statusBarHeight = this.getStatusBarHeight(context);
        this.scaleFactor = (float)screen.x / (float)screen.y > (float)startWidth / (float)startHeight ? 1.0f / ((float)(screen.y - this.statusBarHeight) / (float)startHeight) : 1.0f / ((float)screen.x / (float)startWidth);
    }

    public PhotoViewAttacher(ImageView imageView) {
        this.originalImageView = imageView;
        imageView = this.animateImageLoadIn();
        this.originalImageView.setId(R.id.active_image);
        this.imageView = new WeakReference<ImageView>(imageView);
        imageView.setDrawingCacheEnabled(true);
        imageView.setOnTouchListener((View.OnTouchListener)this);
        ViewTreeObserver observer = imageView.getViewTreeObserver();
        if (null != observer) {
            observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
        if (imageView.isInEditMode()) {
            return;
        }
        this.scaleDragDetector = new GestureDetectorImpl(imageView.getContext(), this);
        this.gestureDetector = new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                if (null != PhotoViewAttacher.this.longClickListener) {
                    PhotoViewAttacher.this.longClickListener.onLongClick((View)PhotoViewAttacher.this.getImageView());
                }
            }
        });
        this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        this.setZoomable(true);
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        if (newOnDoubleTapListener != null) {
            this.gestureDetector.setOnDoubleTapListener(newOnDoubleTapListener);
        } else {
            this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        }
    }

    @Override
    public void setOnScaleChangeListener(OnScaleChangeListener onScaleChangeListener) {
        this.scaleChangeListener = onScaleChangeListener;
    }

    @Override
    public boolean canZoom() {
        return this.zoomEnabled;
    }

    public void cleanup() {
        if (null == this.imageView) {
            return;
        }
        ImageView imageView = (ImageView)this.imageView.get();
        if (null != imageView) {
            ViewTreeObserver observer = imageView.getViewTreeObserver();
            if (null != observer && observer.isAlive()) {
                observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            imageView.setOnTouchListener(null);
            this.cancelFling();
        }
        if (null != this.gestureDetector) {
            this.gestureDetector.setOnDoubleTapListener(null);
        }
        this.matrixChangeListener = null;
        this.imageView = null;
    }

    @Override
    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d;
        ImageView imageView = this.getImageView();
        if (null != imageView && null != (d = imageView.getDrawable())) {
            this.displayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.displayRect);
            return this.displayRect;
        }
        return null;
    }

    @Override
    public boolean setDisplayMatrix(Matrix finalMatrix) {
        if (finalMatrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        ImageView imageView = this.getImageView();
        if (null == imageView) {
            return false;
        }
        if (null == imageView.getDrawable()) {
            return false;
        }
        this.suppMatrix.set(finalMatrix);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
        return true;
    }

    @Override
    public void setRotationTo(float degrees) {
        this.suppMatrix.setRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    @Override
    public void setRotationBy(float degrees) {
        this.suppMatrix.postRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public ImageView getImageView() {
        ImageView imageView = null;
        if (null != this.imageView) {
            imageView = (ImageView)this.imageView.get();
        }
        if (null == imageView) {
            this.cleanup();
            IntercomLogger.i("ImageView no longer exists. You should not use this PhotoViewAttacher any more.");
        }
        return imageView;
    }

    @Override
    public float getMinimumScale() {
        return minScale;
    }

    @Override
    public float getMediumScale() {
        return midScale;
    }

    @Override
    public float getMaximumScale() {
        return mMaxScale;
    }

    @Override
    public float getScale() {
        float x = this.getValue(this.suppMatrix, 0);
        float y = this.getValue(this.suppMatrix, 3);
        return (float)Math.sqrt((float)Math.pow(x, 2.0) + (float)Math.pow(y, 2.0));
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    @Override
    public void onDrag(float dirX, float dirY, float distance) {
        if (this.scaleDragDetector.isScaling()) {
            return;
        }
        ImageView imageView = this.getImageView();
        this.suppMatrix.postTranslate(dirX, dirY);
        this.checkAndDisplayMatrix();
        ViewParent parent = imageView.getParent();
        if (this.allowParentInterceptOnEdge && !this.scaleDragDetector.isScaling() && this.getScale() >= minScale && !this.blockParentIntercept) {
            if ((this.scrollEdge == 2 || this.scrollEdge == 0 && dirX >= 1.0f || this.scrollEdge == 1 && dirX <= -1.0f || this.scrollEdgeTopBottom == 1 && dirY >= 1.0f || this.scrollEdgeTopBottom == 2 && dirY <= -1.0f) && null != parent) {
                float rotate = imageView.getRotation();
                if (dirX < 0.0f && dirY < 0.0f) {
                    rotate -= distance / 100.0f;
                } else if (dirX > 0.0f && dirY < 0.0f) {
                    rotate += distance / 100.0f;
                } else if (dirX > 0.0f && dirY > 0.0f) {
                    rotate -= distance / 100.0f;
                } else if (dirX < 0.0f && dirY > 0.0f) {
                    rotate += distance / 100.0f;
                }
                rotate = rotate < 0.0f ? (rotate < -6.0f ? -6.0f : rotate) : (rotate > 6.0f ? 6.0f : rotate);
                imageView.setRotation(rotate);
                imageView.setX(dirX / 8.0f);
                imageView.setY(dirY / 8.0f);
                this.currentImageAlpha = Math.round(255.0f - Math.abs((imageView.getY() - this.finalYCoordinate) / 2.0f));
                this.currentImageAlpha = this.currentImageAlpha < 50 ? 50 : this.currentImageAlpha;
                this.blackOverlayView.getBackground().setAlpha(this.currentImageAlpha);
                parent.requestDisallowInterceptTouchEvent(false);
            }
        } else if (null != parent) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float startX, float startY, float velocityX, float velocityY) {
        ImageView imageView = this.getImageView();
        this.currentFlingRunnable = new FlingRunnable(imageView.getContext());
        this.currentFlingRunnable.fling(this.getImageViewWidth(imageView), this.getImageViewHeight(imageView), (int)velocityX, (int)velocityY);
        imageView.post((Runnable)this.currentFlingRunnable);
    }

    public void onGlobalLayout() {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (this.zoomEnabled) {
                int top = imageView.getTop();
                int right = imageView.getRight();
                int bottom = imageView.getBottom();
                int left = imageView.getLeft();
                if (top != this.imageViewTop || bottom != this.imageViewBottom || left != this.imageViewLeft || right != this.imageViewRight) {
                    this.updateBaseMatrix(imageView.getDrawable());
                    this.imageViewTop = top;
                    this.imageViewRight = right;
                    this.imageViewBottom = bottom;
                    this.imageViewLeft = left;
                }
            } else {
                this.updateBaseMatrix(imageView.getDrawable());
            }
        }
    }

    @Override
    public void onScale(float scaleFactor, float focusX, float focusY) {
        if (this.getScale() < mMaxScale || scaleFactor < 1.0f) {
            if (null != this.scaleChangeListener) {
                this.scaleChangeListener.onScaleChange(scaleFactor, focusX, focusY);
            }
            this.suppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkAndDisplayMatrix();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent ev) {
        boolean handled = false;
        final ImageView imageView = this.getImageView();
        if (this.zoomEnabled && PhotoViewAttacher.hasDrawable((ImageView)v)) {
            ViewParent parent = v.getParent();
            switch (ev.getAction()) {
                case 0: {
                    if (null != parent) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    } else {
                        IntercomLogger.i("onTouch getParent() returned null");
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    float scale = this.getScale();
                    if (scale < minScale && null != (rect = this.getDisplayRect())) {
                        v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), minScale, rect.centerX(), rect.centerY()));
                        handled = true;
                    }
                    float dy = Math.abs(imageView.getY() - this.finalYCoordinate);
                    float dx = Math.abs(imageView.getX() - this.finalXCoordinate);
                    if (scale == 1.0f && (dy > 20.0f * this.displayMetrics.density || dx > 20.0f * this.displayMetrics.density)) {
                        this.dismiss();
                        break;
                    }
                    if ((dy > 60.0f || dx > 60.0f) && scale != 1.0f && (this.scrollEdge == 0 || this.scrollEdge == 1 || this.scrollEdgeTopBottom == 1 || this.scrollEdgeTopBottom == 2)) {
                        this.setScale(1.0f, true);
                    }
                    this.xPositionSpring.removeAllListeners();
                    this.xPositionSpring.setCurrentValue((double)imageView.getX());
                    this.xPositionSpring.setEndValue((double)this.finalXCoordinate);
                    this.xPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

                        public void onSpringUpdate(Spring spring) {
                            imageView.setX((float)spring.getCurrentValue());
                        }
                    });
                    this.yPositionSpring.removeAllListeners();
                    this.yPositionSpring.setCurrentValue((double)imageView.getY());
                    this.yPositionSpring.setEndValue((double)this.finalYCoordinate);
                    this.yPositionSpring.addListener((SpringListener)new SimpleSpringListener(){

                        public void onSpringUpdate(Spring spring) {
                            imageView.setY((float)spring.getCurrentValue());
                        }
                    });
                    this.rotationSpring.removeAllListeners();
                    this.rotationSpring.setCurrentValue((double)imageView.getRotation());
                    this.rotationSpring.setEndValue(0.0);
                    this.rotationSpring.addListener((SpringListener)new SimpleSpringListener(){

                        public void onSpringUpdate(Spring spring) {
                            imageView.setRotation((float)spring.getCurrentValue());
                        }
                    });
                    this.alphaSpring.removeAllListeners();
                    this.alphaSpring.setCurrentValue((double)this.currentImageAlpha);
                    this.alphaSpring.setEndValue(255.0);
                    this.alphaSpring.addListener((SpringListener)new SimpleSpringListener(){

                        public void onSpringUpdate(Spring spring) {
                            PhotoViewAttacher.this.blackOverlayView.getBackground().setAlpha((int)Math.round(spring.getCurrentValue()));
                        }

                        public void onSpringAtRest(Spring spring) {
                            PhotoViewAttacher.this.currentImageAlpha = 255;
                            super.onSpringAtRest(spring);
                        }
                    });
                    handled = true;
                    break;
                }
            }
            if (null != this.scaleDragDetector) {
                boolean wasScaling = this.scaleDragDetector.isScaling();
                boolean wasDragging = this.scaleDragDetector.isDragging();
                handled = this.scaleDragDetector.onTouchEvent(ev);
                boolean didntScale = !wasScaling && !this.scaleDragDetector.isScaling();
                boolean didntDrag = !wasDragging && !this.scaleDragDetector.isDragging();
                boolean bl = this.blockParentIntercept = didntScale && didntDrag;
            }
            if (null != this.gestureDetector && this.gestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.allowParentInterceptOnEdge = allow;
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        PhotoViewAttacher.checkZoomLevels(minimumScale, midScale, mMaxScale);
        minScale = minimumScale;
    }

    @Override
    public void setMediumScale(float mediumScale) {
        PhotoViewAttacher.checkZoomLevels(minScale, mediumScale, mMaxScale);
        midScale = mediumScale;
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        PhotoViewAttacher.checkZoomLevels(minScale, midScale, maximumScale);
        mMaxScale = maximumScale;
    }

    @Override
    public void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        PhotoViewAttacher.checkZoomLevels(minimumScale, mediumScale, maximumScale);
        minScale = minimumScale;
        midScale = mediumScale;
        mMaxScale = maximumScale;
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.longClickListener = listener;
    }

    @Override
    public void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.matrixChangeListener = listener;
    }

    @Override
    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            this.setScale(scale, imageView.getRight() / 2, imageView.getBottom() / 2, animate);
        }
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (scale < minScale || scale > mMaxScale) {
                IntercomLogger.i("Scale must be within the range of minScale and maxScale");
                return;
            }
            if (animate) {
                imageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
            } else {
                this.suppMatrix.setScale(scale, scale, focalX, focalY);
                this.checkAndDisplayMatrix();
            }
        }
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (PhotoViewAttacher.isSupportedScaleType(scaleType) && scaleType != this.scaleType) {
            this.scaleType = scaleType;
            this.update();
        }
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.zoomEnabled = zoomable;
        this.update();
    }

    public void update() {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (this.zoomEnabled) {
                PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
                this.updateBaseMatrix(imageView.getDrawable());
            } else {
                this.resetMatrix();
            }
        }
    }

    @Override
    public Matrix getDisplayMatrix() {
        return new Matrix(this.getDrawMatrix());
    }

    public Matrix getDrawMatrix() {
        this.drawMatrix.set(this.baseMatrix);
        this.drawMatrix.postConcat(this.suppMatrix);
        return this.drawMatrix;
    }

    private void cancelFling() {
        if (null != this.currentFlingRunnable) {
            this.currentFlingRunnable.cancelFling();
            this.currentFlingRunnable = null;
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private void checkImageViewScaleType() {
        ImageView imageView = this.getImageView();
        if (null != imageView && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            throw new IllegalStateException("The ImageView's ScaleType has been changed since attaching a PhotoViewAttacher");
        }
    }

    private boolean checkMatrixBounds() {
        ImageView imageView = this.getImageView();
        if (null == imageView) {
            return false;
        }
        RectF rect = this.getDisplayRect(this.getDrawMatrix());
        if (null == rect) {
            return false;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getImageViewHeight(imageView);
        if (height <= (float)viewHeight) {
            switch (this.scaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
            this.scrollEdgeTopBottom = 1;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
            this.scrollEdgeTopBottom = 2;
        } else {
            this.scrollEdgeTopBottom = -1;
        }
        int viewWidth = this.getImageViewWidth(imageView);
        if (width <= (float)viewWidth) {
            switch (this.scaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.scrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.scrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.scrollEdge = 1;
        } else {
            this.scrollEdge = -1;
        }
        this.suppMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        ImageView imageView = this.getImageView();
        return imageView == null ? null : imageView.getDrawingCache();
    }

    @Override
    public void setZoomTransitionDuration(int milliseconds) {
        if (milliseconds < 0) {
            milliseconds = 200;
        }
        ZOOM_DURATION = milliseconds;
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.matrixValues);
        return this.matrixValues[whichValue];
    }

    private void resetMatrix() {
        this.suppMatrix.reset();
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            RectF displayRect;
            this.checkImageViewScaleType();
            imageView.setImageMatrix(matrix);
            if (null != this.matrixChangeListener && null != (displayRect = this.getDisplayRect(matrix))) {
                this.matrixChangeListener.onMatrixChanged(displayRect);
            }
        }
    }

    private void updateBaseMatrix(Drawable d) {
        ImageView imageView = this.getImageView();
        if (null == imageView || null == d) {
            return;
        }
        float viewWidth = this.getImageViewWidth(imageView);
        float viewHeight = this.getImageViewHeight(imageView);
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.baseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.scaleType == ImageView.ScaleType.CENTER) {
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.scaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.baseMatrix.postScale(scale, scale);
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.baseMatrix.postScale(scale, scale);
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.scaleType) {
                case FIT_CENTER: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    private int getImageViewWidth(ImageView imageView) {
        if (null == imageView) {
            return 0;
        }
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        if (null == imageView) {
            return 0;
        }
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy scroller;
        private int currentX;
        private int currentY;

        public FlingRunnable(Context context) {
            this.scroller = new ScrollerProxy(context);
        }

        public void cancelFling() {
            this.scroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = PhotoViewAttacher.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.currentX = startX;
            this.currentY = startY;
            if (startX != maxX || startY != maxY) {
                this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.scroller.isFinished()) {
                return;
            }
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (null != imageView && this.scroller.computeScrollOffset()) {
                int newX = this.scroller.getCurrX();
                int newY = this.scroller.getCurrY();
                PhotoViewAttacher.this.suppMatrix.postTranslate((float)(this.currentX - newX), (float)(this.currentY - newY));
                PhotoViewAttacher.this.setImageViewMatrix(PhotoViewAttacher.this.getDrawMatrix());
                this.currentX = newX;
                this.currentY = newY;
                Compat.postOnAnimation((View)imageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float focalX;
        private final float focalY;
        private final long startTime;
        private final float zoomStart;
        private final float zoomEnd;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.focalX = focalX;
            this.focalY = focalY;
            this.startTime = System.currentTimeMillis();
            this.zoomStart = currentZoom;
            this.zoomEnd = targetZoom;
        }

        @Override
        public void run() {
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (imageView == null) {
                return;
            }
            float t = this.interpolate();
            float scale = this.zoomStart + t * (this.zoomEnd - this.zoomStart);
            float deltaScale = scale / PhotoViewAttacher.this.getScale();
            PhotoViewAttacher.this.onScale(deltaScale, this.focalX, this.focalY);
            if (t < 1.0f) {
                Compat.postOnAnimation((View)imageView, this);
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.startTime) / (float)ZOOM_DURATION;
            t = Math.min(1.0f, t);
            t = INTERPOLATOR.getInterpolation(t);
            return t;
        }
    }

    public static interface OnScaleChangeListener {
        public void onScaleChange(float var1, float var2, float var3);
    }

    public static interface OnMatrixChangedListener {
        public void onMatrixChanged(RectF var1);
    }
}

