/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Location;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.utilities.LocationFormatter;
import java.util.Calendar;
import java.util.List;

public class LastParticipatingAdmin
implements Parcelable {
    private static final String TWITTER = "twitter";
    private static final String LINKED_IN = "linkedin";
    private final long lastActiveAt;
    private final String email;
    private final boolean isAdmin;
    private final String name;
    private final String firstName;
    private final boolean isBot;
    private final String intro;
    private final String jobTitle;
    private final Location location;
    private Avatar avatar;
    private SocialAccount twitter;
    private SocialAccount linkedIn;
    public static final Parcelable.Creator<LastParticipatingAdmin> CREATOR = new Parcelable.Creator<LastParticipatingAdmin>(){

        public LastParticipatingAdmin createFromParcel(Parcel in) {
            return new LastParticipatingAdmin(in);
        }

        public LastParticipatingAdmin[] newArray(int size) {
            return new LastParticipatingAdmin[size];
        }
    };
    public static final LastParticipatingAdmin NULL = new LastParticipatingAdmin(new Builder());
    public static final LastParticipatingAdmin NONE = new LastParticipatingAdmin(new Builder());

    public LastParticipatingAdmin(Builder builder) {
        this.avatar = builder.avatar == null ? new Avatar() : builder.avatar.build();
        this.email = builder.email == null ? "" : builder.email;
        this.name = builder.name == null ? "" : builder.name;
        this.firstName = builder.first_name == null ? "" : builder.first_name;
        this.intro = builder.intro == null ? "" : builder.intro;
        this.jobTitle = builder.job_title == null ? "" : builder.job_title;
        this.location = builder.location == null ? new Location() : builder.location.build();
        this.isAdmin = builder.is_admin;
        this.isBot = builder.is_bot;
        this.lastActiveAt = builder.last_active_at;
        this.twitter = SocialAccount.NULL;
        this.linkedIn = SocialAccount.NULL;
        if (builder.social_accounts != null) {
            for (SocialAccount.Builder socialBuilder : builder.social_accounts) {
                SocialAccount socialAccount = socialBuilder.build();
                if (TWITTER.equals(socialAccount.getProvider())) {
                    this.twitter = socialAccount;
                    continue;
                }
                if (!LINKED_IN.equals(socialAccount.getProvider())) continue;
                this.linkedIn = socialAccount;
            }
        }
    }

    public long getLastActiveAt() {
        return this.lastActiveAt;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getName() {
        return this.name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public boolean isBot() {
        return this.isBot;
    }

    public String getIntro() {
        return this.intro;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getLocation(Resources resources) {
        return LocationFormatter.getLocationString(resources, this.location, Calendar.getInstance().getTime());
    }

    public SocialAccount getTwitter() {
        return this.twitter;
    }

    public SocialAccount getLinkedIn() {
        return this.linkedIn;
    }

    protected LastParticipatingAdmin(Parcel in) {
        this.lastActiveAt = in.readLong();
        this.avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
        this.email = in.readString();
        this.isAdmin = in.readByte() != 0;
        this.name = in.readString();
        this.firstName = in.readString();
        this.isBot = in.readByte() != 0;
        this.intro = in.readString();
        this.jobTitle = in.readString();
        this.location = (Location)in.readValue(Location.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.lastActiveAt);
        dest.writeValue((Object)this.avatar);
        dest.writeString(this.email);
        dest.writeByte((byte)(this.isAdmin ? 1 : 0));
        dest.writeString(this.name);
        dest.writeString(this.firstName);
        dest.writeByte((byte)(this.isBot ? 1 : 0));
        dest.writeString(this.intro);
        dest.writeString(this.jobTitle);
        dest.writeValue((Object)this.location);
    }

    public static boolean isNull(LastParticipatingAdmin admin) {
        return admin != NONE && (NULL.equals(admin) || admin == null);
    }

    public static final class Builder {
        private long last_active_at;
        private Avatar.Builder avatar;
        private String email;
        private boolean is_admin;
        private String name;
        private String first_name;
        private boolean is_bot;
        private String intro;
        private String job_title;
        private Location.Builder location;
        private List<SocialAccount.Builder> social_accounts;

        public LastParticipatingAdmin build() {
            return new LastParticipatingAdmin(this);
        }

        @VisibleForTesting
        public Builder withJobTitle(String job_title) {
            this.job_title = job_title;
            return this;
        }

        @VisibleForTesting
        public Builder withIntro(String intro) {
            this.intro = intro;
            return this;
        }

        @VisibleForTesting
        public Builder withName(String name) {
            this.name = name;
            return this;
        }
    }
}

