/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.metrics.MetricObject;

public class MetricFactory {
    public static MetricObject tappedOnLauncher(String launcherType) {
        return MetricFactory.constructMetricObject("messenger_action", "tapped_on_launcher").addMetaData("launcher_type", launcherType);
    }

    public static MetricObject typedInMessageInput(String conversationId) {
        MetricObject metricObject = MetricFactory.constructMetricObject("messenger_action", "typed_in_message_input");
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            metricObject.addMetaData("typing_message_type", "new_conversation");
        } else {
            metricObject.addMetaData("typing_message_type", "reply");
            metricObject.addConversationId(conversationId);
        }
        return metricObject;
    }

    public static MetricObject sentNewMessage(String conversationId, String newMessageType) {
        return MetricFactory.constructMetricObject("messenger_action", "sent_new_message").addConversationId(conversationId).addMetaData("new_message_type", newMessageType);
    }

    public static MetricObject closedMessenger() {
        return MetricFactory.constructMetricObject("messenger_action", "closed_messenger");
    }

    public static MetricObject openedPushMessage(String conversationId, String pushType) {
        return MetricFactory.constructMetricObject("messenger_action", "closed_messenger").addConversationId(conversationId).addMetaData("push_type", pushType);
    }

    public static MetricObject profileExpanded(String conversationId, String profileType) {
        return MetricFactory.constructMetricObject("messenger_action", "profile_expanded").addConversationId(conversationId).addMetaData("profile_type", profileType);
    }

    public static MetricObject tappedOnContentCard() {
        return MetricFactory.constructMetricObject("messenger_action", "tapped_on_content_card");
    }

    public static MetricObject tappedOnSnippet(String conversationId, String messageStyle) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "tapped_on_snippet_in_app").addConversationId(conversationId).addMetaData("message_style", messageStyle);
    }

    public static MetricObject dismissedSnippet(String conversationId, String messageStyle) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "dismissed_snippet_in_app").addConversationId(conversationId).addMetaData("message_style", messageStyle);
    }

    public static MetricObject tappedOnFullInApp(String conversationId, String messageStyle) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "tapped_on_full_in_app").addConversationId(conversationId).addMetaData("message_style", messageStyle);
    }

    public static MetricObject dismissedFullInApp(String conversationId, String messageStyle) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "dismissed_full_in_app").addConversationId(conversationId).addMetaData("message_style", messageStyle);
    }

    public static MetricObject sentReactionMessage(String conversationId) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "selected_reaction").addConversationId(conversationId);
    }

    public static MetricObject reactionViewDisplayed(String conversationId) {
        return MetricFactory.constructMetricObject("messenger_message_response_action", "reactions_displayed").addConversationId(conversationId);
    }

    public static MetricObject tappedIntoInbox() {
        return MetricFactory.constructMetricObject("messenger_inbox_action", "tapped_into_inbox");
    }

    public static MetricObject tappedOnMessageFromInbox(String conversationId) {
        return MetricFactory.constructMetricObject("messenger_inbox_action", "tapped_on_message_from_inbox").addConversationId(conversationId);
    }

    public static MetricObject tappedOnNewChatButton() {
        return MetricFactory.constructMetricObject("messenger_inbox_action", "tapped_on_new_chat_button");
    }

    public static MetricObject channelsLauncherOptIn() {
        return MetricFactory.constructMetricObject("channels_custom_launcher_opt_in", null);
    }

    public static MetricObject channelsMetricObjectOptOut() {
        return MetricFactory.constructMetricObject("channels_custom_launcher_opt_out", null);
    }

    private static MetricObject constructMetricObject(String name, String subAction) {
        return new MetricObject(name, subAction, Injector.get().getUserIdentity().getIntercomId());
    }
}

