/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.inbox.InboxRowViewHolder;
import io.intercom.android.sdk.inbox.LoadingViewHolder;
import io.intercom.android.sdk.interfaces.RecyclerViewClickListener;
import io.intercom.android.sdk.models.Conversation;
import java.util.List;
import java.util.Locale;

public class InboxAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int CONVERSATION = 0;
    private static final int LOADING = 1;
    private final List<Conversation> conversations;
    private final LayoutInflater inflater;
    private final RecyclerViewClickListener recyclerViewClickListener;
    private final TeamPresenceProvider teamPresenceProvider;

    public InboxAdapter(@NonNull LayoutInflater inflater, @NonNull List<Conversation> conversations, @NonNull RecyclerViewClickListener recyclerViewClickListener, @NonNull TeamPresenceProvider teamPresenceProvider) {
        this.inflater = inflater;
        this.conversations = conversations;
        this.recyclerViewClickListener = recyclerViewClickListener;
        this.teamPresenceProvider = teamPresenceProvider;
        this.setHasStableIds(true);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new InboxRowViewHolder(this.inflater.inflate(R.layout.intercom_row_inbox, parent, false), this.teamPresenceProvider, this.recyclerViewClickListener);
        }
        if (viewType == 1) {
            return new LoadingViewHolder(this.inflater.inflate(R.layout.intercom_row_loading, parent, false));
        }
        throw new RuntimeException(String.format(Locale.getDefault(), "View type %d not supported", viewType));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof InboxRowViewHolder) {
            InboxRowViewHolder viewHolder = (InboxRowViewHolder)holder;
            viewHolder.bindData(this.conversations.get(position));
        }
    }

    public int getItemCount() {
        return this.conversations.size();
    }

    public int getItemViewType(int position) {
        return this.conversations.get(position) instanceof Conversation.Loading ? 1 : 0;
    }

    public long getItemId(int position) {
        String id2 = this.conversations.get(position).getId();
        long result = !TextUtils.isEmpty((CharSequence)id2) && TextUtils.isDigitsOnly((CharSequence)id2) ? Long.valueOf(id2) : (long)id2.hashCode();
        return result;
    }
}

