/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.FacebookBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.TwitterBlock;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.LinkUtil;
import io.intercom.android.sdk.views.ButtonSelector;

public class Button
implements ButtonBlock,
FacebookBlock,
TwitterBlock {
    private static final int FACEBOOK_LOGO_PADDING_LEFT_DP = 20;
    private static final int TWITTER_LOGO_PADDING_LEFT_DP = 16;
    private final Context context;
    private final StyleType style;
    private final int facebookLogoPaddingLeftPx;
    private final int twitterLogoPaddingLeftPx;

    public Button(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        this.facebookLogoPaddingLeftPx = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)metrics);
        this.twitterLogoPaddingLeftPx = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)metrics);
    }

    public View addButton(String text, String url, BlockAlignment alignment, boolean isFirstBlock, boolean isLastBlock, ViewGroup parent) {
        Object view = this.style == StyleType.NOTE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD ? this.createFullWidthButton(this.context, text) : this.createDefaultTextView(text, alignment);
        return this.setButtonDefaults((View)view, url, alignment, isLastBlock);
    }

    public View addFacebookButton(String url, BlockAlignment blockAlignment, boolean isFirstBlock, boolean isLastBlock, ViewGroup viewGroup) {
        String text = this.context.getString(R.string.intercom_facebook_like);
        Object view = this.style == StyleType.NOTE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD ? this.createButtonWithLogo(this.context, text, this.facebookLogoPaddingLeftPx, R.drawable.intercomsdk_icn_fb) : this.createDefaultTextView(text, blockAlignment);
        return this.setButtonDefaults((View)view, url, blockAlignment, isLastBlock);
    }

    public View addTwitterButton(String url, BlockAlignment blockAlignment, boolean isFirstBlock, boolean isLastBlock, ViewGroup viewGroup) {
        String text = this.context.getString(R.string.intercom_twitter_follow);
        Object view = this.style == StyleType.NOTE || this.style == StyleType.POST || this.style == StyleType.CONTAINER_CARD ? this.createButtonWithLogo(this.context, text, this.twitterLogoPaddingLeftPx, R.drawable.intercomsdk_icn_twitter) : this.createDefaultTextView(text, blockAlignment);
        return this.setButtonDefaults((View)view, url, blockAlignment, isLastBlock);
    }

    private View setButtonDefaults(View view, final String url, BlockAlignment alignment, boolean isLastObject) {
        if (this.style != StyleType.CHAT_FULL) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    LinkUtil.openUrl(url, Button.this.context);
                }
            });
        }
        BlockUtils.setLayoutMarginsAndGravity(view, alignment.getGravity(), isLastObject);
        return view;
    }

    private TextView createDefaultTextView(String text, BlockAlignment alignment) {
        ParagraphView textView = new ParagraphView(this.context, this.style, alignment);
        textView.setTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        textView.setPaintFlags(textView.getPaintFlags() | 8);
        textView.setGravity(alignment.getGravity());
        textView.setText(text);
        return textView;
    }

    private android.widget.Button createFullWidthButton(Context context, String text) {
        android.widget.Button button = new android.widget.Button(context);
        button.setTextSize(2, 16.0f);
        button.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        button.setAllCaps(false);
        button.setGravity(17);
        button.setText((CharSequence)text);
        BlockUtils.createLayoutParams((View)button, -1, -2);
        BlockUtils.setDefaultMarginBottom((View)button);
        BackgroundUtils.setBackground((View)button, (Drawable)new ButtonSelector(context, R.drawable.intercom_border));
        FontUtils.setTypeface(context, (TextView)button, "intercom_roboto_medium.ttf");
        return button;
    }

    private View createButtonWithLogo(Context context, String text, int paddingLeft, @DrawableRes int logoResource) {
        FrameLayout frame = new FrameLayout(context);
        BlockUtils.createLayoutParams((View)frame, -1, ScreenUtils.convertDpToPixel((float)44.0f, (Context)context));
        BlockUtils.setDefaultMarginBottom((View)frame);
        BackgroundUtils.setBackground((View)frame, (Drawable)new ButtonSelector(context, R.drawable.intercom_border));
        ((LinearLayout.LayoutParams)frame.getLayoutParams()).gravity = 17;
        ImageView logo = new ImageView(context);
        BlockUtils.createLayoutParams((View)logo, -2, -1);
        logo.setImageResource(logoResource);
        logo.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_full_transparent_full_black));
        logo.setPadding(paddingLeft, 0, 0, 0);
        ((LinearLayout.LayoutParams)logo.getLayoutParams()).gravity = 19;
        TextView textView = new TextView(context);
        BlockUtils.createLayoutParams((View)textView, -1, -1);
        textView.setText((CharSequence)text);
        textView.setTextSize(2, 16.0f);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        textView.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_full_transparent_full_black));
        textView.setGravity(17);
        FontUtils.setTypeface(context, textView, "intercom_roboto_medium.ttf");
        frame.addView((View)logo);
        frame.addView((View)textView);
        return frame;
    }
}

