/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.annotations.IntercomExclusionStrategy;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.IdentityInterceptor;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.StringUtils;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.com.google.gson.ExclusionStrategy;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.google.gson.GsonBuilder;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.okhttp3.Cache;
import io.intercom.okhttp3.CertificatePinner;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.MultipartBody;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.Response;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Converter;
import io.intercom.retrofit2.Retrofit;
import io.intercom.retrofit2.converter.gson.GsonConverterFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class Api {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME = ".mobile-sdk-api.intercom.io";
    private static final String ENDPOINT = "/oreo/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    private final CallbackHolder callbacks;
    private final String appId;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private IntercomApiInterface intercomApiInterface;
    private boolean synchronous;

    public Api(Context context, String appId, boolean synchronous, AppIdentity appIdentity, UserIdentity userIdentity) {
        this.appId = appId;
        this.synchronous = synchronous;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.intercomApiInterface = this.createIntercomApiInterface(context, appIdentity, userIdentity);
        this.callbacks = new CallbackHolder();
    }

    public void configureRequestSynchronicity(Context context, boolean hasIntercomId) {
        if (hasIntercomId == this.synchronous) {
            this.synchronous = !hasIntercomId;
            this.intercomApiInterface = this.createIntercomApiInterface(context, this.appIdentity, this.userIdentity);
        }
    }

    protected IntercomApiInterface createIntercomApiInterface(@NonNull Context context, AppIdentity appIdentity, UserIdentity userIdentity) {
        return (IntercomApiInterface)this.configureRestAdapter(context, this.synchronous, appIdentity, userIdentity).create(IntercomApiInterface.class);
    }

    private Retrofit configureRestAdapter(Context context, boolean synchronousRequests, AppIdentity appIdentity, UserIdentity userIdentity) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).addInterceptor((Interceptor)new IdentityInterceptor(appIdentity, userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addNetworkInterceptor((Interceptor)HeaderInterceptor.create(context, appIdentity));
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        builder.cache(new Cache(cacheDirectory, 0xA00000L));
        String hostname = Api.getFullHostname(DeviceUtils.getAppVersion((Context)context), this.appId);
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(hostname, new String[]{"sha1/BiCgk94N+oILO/VULX+wYS6gWKU="}).build();
        builder.certificatePinner(certificatePinner);
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new IntercomExclusionStrategy()}).create();
        OkHttpClient client = builder.build();
        if (synchronousRequests) {
            client.dispatcher().setMaxRequests(1);
        }
        return new Retrofit.Builder().baseUrl(this.getHostname(context)).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
    }

    public void registerUnidentifiedUser() {
        this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(this.getContext()), true), this.userIdentity.getFingerprint());
    }

    public void registerIdentifiedUser(Registration registration) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.getContext());
        if (!registration.getGcmRegistrationId().isEmpty()) {
            deviceData.put(DEVICE_TOKEN, registration.getGcmRegistrationId());
        }
        Map<String, Object> params = this.generateUpdateUserParams(deviceData, true);
        params.put(USER_ATTRIBUTES, registration.getAttributes());
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    public void ping() {
        if (this.userIdentity.identityExists() && this.appIdentity.identityExists()) {
            this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(this.getContext()), true), this.userIdentity.getFingerprint());
        }
    }

    public void setGcmPushKey(String gcmRegistrationId) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.getContext());
        deviceData.put(DEVICE_TOKEN, gcmRegistrationId);
        this.retriableUpdateUser(this.generateUpdateUserParams(deviceData, false), this.userIdentity.getFingerprint());
    }

    public void removeGcmDeviceToken(String token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_TOKEN, token);
        this.intercomApiInterface.deleteDeviceToken(params).enqueue((Callback)new Callback<UsersResponse.Builder>(){

            public void onResponse(Call<UsersResponse.Builder> call, io.intercom.retrofit2.Response<UsersResponse.Builder> response) {
            }

            public void onFailure(Call<UsersResponse.Builder> call, Throwable t) {
            }
        });
    }

    public void updateUser(Map<String, ?> attributes) {
        Map<String, Object> params = this.generateUpdateUserParams(DeviceData.generateDeviceData(this.getContext()), false);
        params.put(USER_ATTRIBUTES, attributes);
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    protected void retriableUpdateUser(final Map<String, Object> params, final String fingerprint) {
        this.intercomApiInterface.updateUser(params).enqueue((Callback)new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            public void onSuccess(UpdateUserResponse.Builder builder) {
                if (fingerprint.equals(Api.this.userIdentity.getFingerprint())) {
                    IntercomLogger.i("Successfully registered or updated user");
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                    Api.this.callbacks.teamPresenceCallback().onSuccess(builder);
                }
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(errorObject, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint);
                }
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        this.addSecureHash(params);
        this.intercomApiInterface.logEvent(params).enqueue(this.callbacks.unreadCallback());
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.markAsRead(conversationId, params).enqueue(this.callbacks.readCallback());
        this.getBus().post((Object)new ReadEvent(conversationId));
    }

    public void markConversationAsDismissed(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("conversation_ids", new String[]{conversationId});
        this.addSecureHash(params);
        this.intercomApiInterface.markAsDismissed(params).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, io.intercom.retrofit2.Response<Void> response) {
            }

            public void onFailure(Call<Void> call, Throwable t) {
            }
        });
    }

    public void getInbox() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getUnreadConversations(params).enqueue(this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.intercomApiInterface.getConversation(conversationId, params).enqueue(this.callbacks.conversationCallback());
    }

    public void textReply(String conversationId, String messageText, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("body", messageText);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params).enqueue(this.callbacks.replyCallback(tempPartPosition, false, tempPartId, conversationId));
        this.getMetricsStore().track(MetricFactory.sentNewMessage(conversationId, "reply"));
    }

    public void reactToConversation(String conversationId, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.intercomApiInterface.reactToConversation(conversationId, params).enqueue(this.callbacks.reactCallback());
    }

    public void attachmentReply(String conversationId, int uploadId, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params).enqueue(this.callbacks.replyCallback(tempPartPosition, true, tempPartId, conversationId));
        this.getMetricsStore().track(MetricFactory.sentNewMessage(conversationId, "reply"));
    }

    public void startNewConversation(String messageText, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("body", messageText);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void startNewAttachmentConversation(int uploadId, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void uploadFile(final File file, final String originalFileName, long size, final String mimeType, int width, int height, final int tempPartPosition, final String tempPartId, final UploadProgressListener listener) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", size);
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", width);
        uploadMap.put("height", height);
        params.put(UPLOAD, uploadMap);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.uploadFile(params).enqueue((Callback)new BaseCallback<Upload.Builder>(){

            @Override
            public void onSuccess(Upload.Builder builder) {
                final Upload uploadResponse = builder.build();
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), file, listener)).build();
                new OkHttpClient().newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post((RequestBody)requestBody).build()).enqueue(new io.intercom.okhttp3.Callback(){

                    public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                        IntercomLogger.e("Upload failed: " + e.getMessage());
                        Api.this.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                        IntercomLogger.internal("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Api.this.getBus().post((Object)new UploadEvent(uploadResponse.getId(), tempPartPosition, tempPartId));
                        } else {
                            IntercomLogger.e("Upload failed: request body " + response.body());
                            Api.this.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        response.body().close();
                    }
                });
                IntercomLogger.internal("API Success", "Successfully uploaded");
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Api.this.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Upload failed", error);
            }
        });
    }

    public void sendMetrics(List<MetricObject> metrics, Callback<Void> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metrics", metrics);
        this.intercomApiInterface.sendMetrics(params).enqueue(callback);
    }

    public void getVideo(String url, io.intercom.okhttp3.Callback callback) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(new io.intercom.okhttp3.Callback(){

            public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                IntercomLogger.internal("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                IntercomLogger.internal("Tracking Url", "success");
                response.body().close();
            }
        });
    }

    protected String getHostname(Context context) {
        return Api.convertHostnameToUrl(Api.getFullHostname(DeviceUtils.getAppVersion((Context)context), this.appId));
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String version, String appId) {
        return Api.createUniqueIdentifier(version, appId) + PARTIAL_HOSTNAME;
    }

    static String createUniqueIdentifier(String version, String appId) {
        String result;
        List tokens = StringUtils.splitOnEmpty((String)version.replaceAll("[^\\d]", ""));
        StringBuilder sb = new StringBuilder(appId);
        sb.append("-android");
        if (!tokens.isEmpty()) {
            sb.append("-");
            sb.append(TextUtils.join((CharSequence)"-", (Iterable)tokens));
        }
        if (sb.length() > 63) {
            int endIndex = 63;
            if (sb.charAt(62) == '-') {
                --endIndex;
            }
            result = sb.substring(0, endIndex);
        } else {
            result = sb.toString();
        }
        return result;
    }

    protected static int getRetryTimer(int count) {
        return (int)(Math.pow(2.0, count) * 1000.0);
    }

    protected static boolean isUserNotFound(ErrorObject error, Map userParams) {
        if (error.hasErrorBody() && error.getStatusCode() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1) {
            try {
                JSONObject errorObject = new JSONObject(error.getErrorBody());
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                IntercomLogger.internal("Could not parse error response");
            }
        }
        return false;
    }

    private void addSecureHash(Map<String, Object> params) {
        String secureData = this.userIdentity.getData();
        String secureHmac = this.userIdentity.getHmac();
        if (!TextUtils.isEmpty((CharSequence)secureData) && !TextUtils.isEmpty((CharSequence)secureHmac)) {
            params.put(DATA, secureData);
            params.put(HMAC, secureHmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(Map<String, Object> deviceData, boolean newSession) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, deviceData);
        params.put(NEW_SESSION, newSession);
        this.addSecureHash(params);
        return params;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    private Context getContext() {
        return Injector.get().getApplication();
    }

    private Bus getBus() {
        return Injector.get().getBus();
    }

    private MetricsStore getMetricsStore() {
        return Injector.get().getMetricsStore();
    }

    public static interface Provider {
        public Api getApi();
    }
}

