/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.fragments.MaterialDialog;
import io.intercom.android.sdk.inbox.ConversationsListFragment;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseMessengerEvent;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.android.sdk.views.StatusBarThemer;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import io.intercom.com.squareup.otto.Subscribe;

public class IntercomMessengerActivity
extends AppCompatActivity
implements ConversationsListFragment.Listener,
ConversationFragment.Listener,
MaterialDialog.Callback,
View.OnClickListener,
IntercomToolbar.Listener {
    private static final int MESSAGE_FAILED_DIALOG = 1;
    private static final int DRAG_CHANGE_THRESHOLD_DP = 100;
    private static final int SPRING_TENSION = 600;
    private static final int SPRING_FRICTION = 40;
    @VisibleForTesting
    protected static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    public static final String SHOW_INBOX = "showInbox";
    public static final String LAST_PARTICIPANT = "last_participant";
    private final ConversationsListFragment inbox = ConversationsListFragment.getInstance();
    private FrameLayout containerView;
    private View background;
    private IntercomToolbar intercomToolbar;
    private Spring spring;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_iam);
        this.setUpSpringSystem();
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.setUpToolBar();
        this.containerView = (FrameLayout)this.findViewById(R.id.iam_container);
        this.containerView.setVisibility(8);
        Injector.init(this.getApplication());
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector.get().getBus().register((Object)this);
        this.getSupportFragmentManager().addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                ConversationsListFragment conversationsListFragment = (ConversationsListFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationsListFragment.class.getName());
                if (conversationsListFragment != null && conversationsListFragment.isVisible()) {
                    IntercomMessengerActivity.this.switchToConversationListToolbar();
                }
            }
        });
    }

    private int getScreenHeight() {
        return this.findViewById(0x1020002).getMeasuredHeight();
    }

    protected void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowInbox = false;
        if (data != null) {
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                conversationId = data.getString(PARCEL_CONVERSATION_ID);
            }
            if (data.containsKey(SHOW_INBOX)) {
                shouldShowInbox = data.getBoolean(SHOW_INBOX);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        this.intercomToolbar.setOnClickListener(this);
        this.intercomToolbar.setUpFullToolbar();
        if (shouldShowInbox) {
            this.displayFragment((Fragment)this.inbox, ConversationsListFragment.class.getName(), false);
        } else {
            this.loadConversation(conversationId, lastParticipatingAdmin, false, false);
        }
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.background.post(new Runnable(){

                    @Override
                    public void run() {
                        IntercomMessengerActivity.this.animateSdkWindowIn();
                    }
                });
            }
        });
    }

    private void setUpSpringSystem() {
        this.spring = SpringSystem.create().createSpring();
        this.spring.setSpringConfig(new SpringConfig(600.0, 40.0));
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        IntercomLogger.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.iam_fragment, frag, tag);
        if (addToBackStack) {
            IntercomLogger.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commit();
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            this.closeMessenger();
        } else if (this.containerView.getRootView().findViewById(R.id.lightbox_image) != null) {
            ImageView lightboxImage = (ImageView)this.containerView.getRootView().findViewById(R.id.lightbox_image);
            ImageView originalImageView = (ImageView)this.containerView.getRootView().findViewById(R.id.active_image);
            View blackOverlayView = this.containerView.getRootView().findViewById(R.id.lightbox_overlay);
            if (lightboxImage == null || originalImageView == null || blackOverlayView == null) {
                return;
            }
            originalImageView.setVisibility(0);
            originalImageView.setId(R.id.not_active_image);
            this.containerView.removeView((View)lightboxImage);
            this.containerView.removeView(blackOverlayView);
            this.containerView.setOnTouchListener(null);
        } else {
            this.intercomToolbar.setInboxButtonVisibility(8);
            super.onBackPressed();
        }
    }

    @Override
    public void inboxRowSelected() {
        this.intercomToolbar.fadeOutInbox();
    }

    @Override
    public void loadConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack) {
        this.intercomToolbar.setNavigationItem(addToBackStack);
        this.displayFragment((Fragment)ConversationFragment.newInstance(conversationId, participant, isRead), ConversationFragment.class.getName(), addToBackStack);
    }

    @Override
    public void showErrorMessageDialog() {
        MaterialDialog dialog = MaterialDialog.getInstance(1, R.string.intercom_message_error, R.string.intercom_message_error_message, R.string.intercom_retry, 0);
        dialog.show(this.getSupportFragmentManager(), MaterialDialog.class.getName());
    }

    @Override
    public void setCountVisible() {
        this.intercomToolbar.setInboxButtonVisibility(0);
    }

    private void animateToOriginalSize() {
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.containerView.getHeight());
        this.spring.setEndValue((double)this.getScreenHeight());
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                ((IntercomMessengerActivity)IntercomMessengerActivity.this).containerView.getLayoutParams().height = (int)spring.getCurrentValue();
                IntercomMessengerActivity.this.containerView.requestLayout();
            }

            public void onSpringAtRest(Spring spring) {
                ((IntercomMessengerActivity)IntercomMessengerActivity.this).containerView.getLayoutParams().height = -1;
                IntercomMessengerActivity.this.hideBackgroundColor();
            }
        });
    }

    private void animateSdkWindowIn() {
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.getScreenHeight());
        this.spring.setEndValue(0.0);
        this.spring.setRestDisplacementThreshold(2.0);
        this.spring.setRestDisplacementThreshold(2.0);
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringAtRest(Spring spring) {
                IntercomMessengerActivity.this.hideBackgroundColor();
                ConversationFragment fragment = (ConversationFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
                if (fragment != null) {
                    fragment.sdkWindowFinishedAnimating();
                }
            }

            public void onSpringActivate(Spring spring) {
                IntercomMessengerActivity.this.containerView.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomMessengerActivity.this.containerView.setY(value);
            }
        });
    }

    public void closeMessenger() {
        this.hideKeyboard();
        this.animateSdkWindowOut();
        this.fadeOutBackground();
        Injector.get().getMetricsStore().track(MetricFactory.closedMessenger());
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void animateSdkWindowOut() {
        this.showBackgroundColour();
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.containerView.getY());
        this.spring.setEndValue((double)this.getWindow().getDecorView().getHeight());
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomMessengerActivity.this.containerView.setY(value);
            }
        });
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                IntercomMessengerActivity.this.background.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.finish();
                IntercomMessengerActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    private void switchToConversationListToolbar() {
        this.setUpToolBar();
    }

    private void setUpToolBar() {
        this.setToolbarColor();
        String appName = Injector.get().getAppIdentity().getAppConfig().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_chats));
        } else {
            this.intercomToolbar.setTitle(String.format(this.getString(R.string.intercom_chats_with), appName));
        }
    }

    @Override
    public void setToolbarColor() {
        this.intercomToolbar.setBackgroundColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    private void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    @Override
    public void setStatusBarColor() {
        StatusBarThemer.setStatusBarColor(this.getWindow());
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
    }

    public static Intent openConversation(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        return intent;
    }

    @Subscribe
    public void closeSdk(CloseMessengerEvent event) {
        this.finish();
    }

    @Override
    public void onPrimaryButtonClicked(int requestCode) {
        ConversationFragment fragment;
        if (requestCode == 1 && (fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName())) != null) {
            fragment.retryTapped();
        }
    }

    @Override
    public void onSecondaryButtonClicked(int requestCode) {
    }

    @Override
    public void onCloseClicked() {
        this.closeMessenger();
    }

    @Override
    public void onInboxClicked() {
        this.switchToConversationListToolbar();
        ConversationsListFragment fragment = (ConversationsListFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationsListFragment.class.getName());
        if (fragment != null) {
            this.onBackPressed();
        } else {
            this.displayFragment((Fragment)this.inbox, ConversationsListFragment.class.getName(), false);
        }
    }

    @Override
    public void setToolbarTitle(String title) {
        this.intercomToolbar.setTitle(title);
    }

    @Override
    public void setToolbarBackground(@ColorRes int color2) {
        this.intercomToolbar.setBackgroundColor(ContextCompat.getColor((Context)this, (int)color2));
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }

    public void onClick(View v) {
        ConversationFragment fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
        if (fragment != null) {
            fragment.toggleProfile();
        }
    }
}

